/*
 * Decompiled with CFR 0.152.
 */
package org.monospark.geometrix.shape.flat.polygon.model;

import java.util.LinkedHashSet;
import org.monospark.geometrix.dimensions.Dimension;
import org.monospark.geometrix.dimensions.Two;
import org.monospark.geometrix.shape.flat.polygon.model.PolygonModel;
import org.monospark.geometrix.shape.flat.polygon.model.PolygonModelFactory;
import org.monospark.geometrix.shape.flat.polygon.model.PolygonModelType;
import org.monospark.geometrix.vector.Vec;

public final class PolygonModelBuilder {
    private final LinkedHashSet<Vec<Two>> points = new LinkedHashSet();

    public PolygonModelBuilder add(double x, double y) {
        Vec<Two> point = Vec.create(Dimension.TWO, x, y);
        if (this.points.contains(point)) {
            throw new IllegalArgumentException("Point was already added to the builder");
        }
        this.points.add(point);
        return this;
    }

    public <T extends PolygonModelType> PolygonModel<T> createPolygonModel(T type, int actions) {
        return PolygonModelFactory.createPolygonModel(type, this.points, actions).orElseThrow(() -> new IllegalArgumentException("The polygon model can't be created"));
    }

    public PolygonModel<PolygonModelType.Convex> createConvexHull() {
        return PolygonModelFactory.createConvexHull(this.points).orElseThrow(() -> new IllegalArgumentException("A convex hull couldn't be created"));
    }
}

