/*
 * Decompiled with CFR 0.152.
 */
package org.monospark.geometrix.shape.flat.polygon.model;

import org.monospark.geometrix.dimensions.Two;
import org.monospark.geometrix.shape.flat.FlatShapeModel;
import org.monospark.geometrix.shape.flat.polygon.PolygonExterior;
import org.monospark.geometrix.shape.flat.polygon.model.PolygonModelPointOrder;
import org.monospark.geometrix.shape.flat.polygon.model.PolygonModelType;
import org.monospark.geometrix.vector.Vec;

public final class PolygonModel<T extends PolygonModelType>
extends FlatShapeModel {
    private final PolygonModelPointOrder pointOrder;
    private final T type;
    private final PolygonExterior<Two> exterior;

    PolygonModel(double area, T type, PolygonExterior<Two> exterior, PolygonModelPointOrder pointOrder) {
        super(area);
        this.pointOrder = pointOrder;
        this.type = type;
        this.exterior = exterior;
    }

    @Override
    protected boolean isPointOnModel(Vec<Two> point) {
        return ((PolygonModelType)this.type).isPointOnModel(this, point);
    }

    @Override
    public boolean resembles(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof PolygonModel) {
            PolygonModel m = (PolygonModel)o;
            return m.exterior.resembles(this.exterior);
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof PolygonModel) {
            PolygonModel m = (PolygonModel)o;
            return m.type.equals(this.type) && m.pointOrder.equals(this.pointOrder) && m.getArea() == this.getArea() && m.exterior.equals(this.exterior);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 3 * this.type.hashCode() + 5 * this.pointOrder.hashCode() + 7 * Double.hashCode(this.getArea()) + 11 * this.exterior.hashCode();
    }

    @Override
    public String toString() {
        return "polygon model: {type: " + this.type + ", order: " + this.pointOrder + ", area: " + this.getArea() + ", exterior: " + this.exterior + "}";
    }

    public PolygonModelPointOrder getPointOrder() {
        return this.pointOrder;
    }

    public PolygonModelType getType() {
        return this.type;
    }

    public PolygonExterior<Two> getExterior() {
        return this.exterior;
    }
}

