/*
 * Decompiled with CFR 0.152.
 */
package org.monospark.geometrix.shape.flat.polygon;

import org.monospark.geometrix.GeometrixObject;
import org.monospark.geometrix.dimensions.TwoMin;
import org.monospark.geometrix.vector.Vec;

public final class PolygonVertex<D extends TwoMin>
extends GeometrixObject {
    private final Vec<D> point;
    private final Vec<D> normal;

    public PolygonVertex(Vec<D> point, Vec<D> normal) {
        this.point = point;
        this.normal = normal;
    }

    @Override
    public boolean resembles(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof PolygonVertex) {
            PolygonVertex v = (PolygonVertex)o;
            return v.point.resembles(this.point) && v.normal.resembles(this.normal);
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof PolygonVertex) {
            PolygonVertex v = (PolygonVertex)o;
            return v.point.equals(this.point) && v.normal.equals(this.normal);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 13 * this.point.hashCode() + 31 * this.normal.hashCode();
    }

    @Override
    public String toString() {
        return "vertex: {point=" + this.point + ", normal=" + this.normal + "}";
    }

    public Vec<D> getPoint() {
        return this.point;
    }

    public Vec<D> getNormal() {
        return this.normal;
    }
}

