/*
 * Decompiled with CFR 0.152.
 */
package org.monospark.geometrix.shape.flat.polygon;

import java.util.Collections;
import java.util.List;
import org.monospark.geometrix.GeometrixObject;
import org.monospark.geometrix.dimensions.TwoMin;
import org.monospark.geometrix.shape.flat.polygon.PolygonEdge;
import org.monospark.geometrix.shape.flat.polygon.PolygonVertex;
import org.monospark.geometrix.util.ListHelper;

public final class PolygonExterior<D extends TwoMin>
extends GeometrixObject {
    private final List<PolygonVertex<D>> vertices;
    private final List<PolygonEdge<D>> edges;

    public PolygonExterior(List<PolygonVertex<D>> vertices, List<PolygonEdge<D>> edges) {
        this.vertices = Collections.unmodifiableList(vertices);
        this.edges = Collections.unmodifiableList(edges);
    }

    @Override
    public boolean resembles(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof PolygonExterior) {
            PolygonExterior v = (PolygonExterior)o;
            return ListHelper.areListContentOrdersEqual(v.vertices, this.vertices, (v1, v2) -> v1.resembles(v2));
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof PolygonExterior) {
            PolygonExterior v = (PolygonExterior)o;
            return v.vertices.equals(this.vertices) && v.edges.equals(this.edges);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 13 * this.vertices.hashCode() + 31 * this.edges.hashCode();
    }

    @Override
    public String toString() {
        return "exterior: {vertices: " + this.vertices + ", edges: " + this.edges + "}";
    }

    public List<PolygonVertex<D>> getVertices() {
        return this.vertices;
    }

    public List<PolygonEdge<D>> getEdges() {
        return this.edges;
    }
}

