/*
 * Decompiled with CFR 0.152.
 */
package org.monospark.geometrix.shape.flat.polygon;

import org.monospark.geometrix.GeometrixObject;
import org.monospark.geometrix.dimensions.TwoMin;
import org.monospark.geometrix.lineseg.LineSeg;
import org.monospark.geometrix.vector.Vec;

public final class PolygonEdge<D extends TwoMin>
extends GeometrixObject {
    private final LineSeg<D> lineSeg;
    private final Vec<D> normal;

    public PolygonEdge(LineSeg<D> lineSeg, Vec<D> normal) {
        this.lineSeg = lineSeg;
        this.normal = normal;
    }

    @Override
    public boolean resembles(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof PolygonEdge) {
            PolygonEdge v = (PolygonEdge)o;
            return v.lineSeg.resembles(this.lineSeg) && v.normal.resembles(this.normal);
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof PolygonEdge) {
            PolygonEdge v = (PolygonEdge)o;
            return v.lineSeg.equals(this.lineSeg) && v.normal.equals(this.normal);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 13 * this.lineSeg.hashCode() + 31 * this.normal.hashCode();
    }

    @Override
    public String toString() {
        return "edge: {line segment=" + this.lineSeg + ", normal=" + this.normal + "}";
    }

    public LineSeg<D> getLineSegment() {
        return this.lineSeg;
    }

    public Vec<D> getNormal() {
        return this.normal;
    }
}

