/*
 * Decompiled with CFR 0.152.
 */
package org.monospark.geometrix.shape.flat.polygon;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.monospark.geometrix.dimensions.TwoMin;
import org.monospark.geometrix.lineseg.LineSeg;
import org.monospark.geometrix.shape.flat.FlatShape;
import org.monospark.geometrix.shape.flat.alignment.Alignment;
import org.monospark.geometrix.shape.flat.polygon.PolygonEdge;
import org.monospark.geometrix.shape.flat.polygon.PolygonExterior;
import org.monospark.geometrix.shape.flat.polygon.PolygonVertex;
import org.monospark.geometrix.shape.flat.polygon.model.PolygonModel;
import org.monospark.geometrix.shape.flat.polygon.model.PolygonModelType;
import org.monospark.geometrix.vector.Vec;

public class Polygon<T extends PolygonModelType, D extends TwoMin, A extends Alignment<D>>
extends FlatShape<PolygonModel<T>, D, A> {
    private final PolygonExterior<D> exterior;

    public static <T extends PolygonModelType, D extends TwoMin, A extends Alignment<D>> Polygon<T, D, A> create(PolygonModel<T> model, A alignment) {
        return Polygon.createOptional(model, alignment).orElseThrow(() -> new IllegalArgumentException("Polygon does not lie completely inside object space"));
    }

    public static <T extends PolygonModelType, D extends TwoMin, A extends Alignment<D>> Optional<Polygon<T, D, A>> createOptional(PolygonModel<T> model, A alignment) {
        int i;
        Objects.requireNonNull(alignment, "Alignment must be not null");
        Objects.requireNonNull(model, "Polygon model must be not null");
        ArrayList realVertices = new ArrayList();
        ArrayList realEdges = new ArrayList();
        for (i = 0; i < model.getExterior().getVertices().size(); ++i) {
            Vec<D> realPoint = alignment.getGlobalPoint(model.getExterior().getVertices().get(i).getPoint());
            if (!Vec.isInObjectSpace(realPoint)) {
                return Optional.empty();
            }
            Vec<D> realNormal = alignment.getGlobalDirection(model.getExterior().getVertices().get(i).getNormal());
            PolygonVertex<D> realVertex = new PolygonVertex<D>(realPoint, realNormal);
            realVertices.add(realVertex);
        }
        for (i = 0; i < model.getExterior().getEdges().size(); ++i) {
            Vec<D> realP1 = alignment.getGlobalPoint(model.getExterior().getEdges().get(i).getLineSegment().getP1());
            Vec<D> realP2 = alignment.getGlobalPoint(model.getExterior().getEdges().get(i).getLineSegment().getP2());
            Vec<D> realNormal = alignment.getGlobalDirection(model.getExterior().getEdges().get(i).getNormal());
            PolygonEdge<D> realEdge = new PolygonEdge<D>(LineSeg.create(realP1, realP2), realNormal);
            realEdges.add(realEdge);
        }
        return Optional.of(new Polygon(model, alignment, new PolygonExterior(realVertices, realEdges)));
    }

    private Polygon(PolygonModel<T> model, A alignment, PolygonExterior<D> exterior) {
        super(model, alignment);
        this.exterior = exterior;
    }

    @Override
    public boolean resembles(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof Polygon) {
            Polygon p = (Polygon)o;
            if (!p.getDimension().equals(this.getDimension())) {
                return false;
            }
            return p.exterior.resembles(this.exterior);
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof Polygon) {
            Polygon p = (Polygon)o;
            return p.alignment.equals(this.alignment) && ((PolygonModel)p.model).equals(this.model);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 13 * this.alignment.hashCode() * 31 * ((PolygonModel)this.model).hashCode();
    }

    @Override
    public String toString() {
        return "polygon: {alignment: " + this.alignment + ", model: " + this.model + ", exterior: " + this.exterior.toString() + "}";
    }

    public PolygonExterior<D> getExterior() {
        return this.exterior;
    }
}

