/*
 * Decompiled with CFR 0.152.
 */
package org.monospark.geometrix.shape.flat.ellipseseg;

import java.util.Optional;
import org.monospark.geometrix.dimensions.Dimension;
import org.monospark.geometrix.dimensions.Two;
import org.monospark.geometrix.shape.flat.FlatShapeModel;
import org.monospark.geometrix.util.RoundingHelper;
import org.monospark.geometrix.vector.Vec;

public final class EllipseSegModel
extends FlatShapeModel {
    private final double xRadius;
    private final double yRadius;
    private final double height;
    private final Vec<Two> top;
    private final Vec<Two> left;
    private final Vec<Two> right;

    public static EllipseSegModel create(double xRadius, double yRadius, double height) {
        return EllipseSegModel.createOptional(xRadius, yRadius, height).orElseThrow(() -> new IllegalArgumentException("The are of the ellipse segment model is infinite"));
    }

    public static Optional<EllipseSegModel> createOptional(double xRadius, double yRadius, double height) {
        if (Double.isInfinite(xRadius) || Double.isNaN(xRadius) || xRadius <= 0.0) {
            throw new IllegalArgumentException("Invalid x-radius: " + xRadius);
        }
        if (Double.isInfinite(yRadius) || Double.isNaN(yRadius) || yRadius <= 0.0) {
            throw new IllegalArgumentException("Invalid y-radius: " + yRadius);
        }
        if (Double.isInfinite(height) || Double.isNaN(height) || height <= 0.0) {
            throw new IllegalArgumentException("Invalid height value: " + height);
        }
        if (height > yRadius * 2.0) {
            throw new IllegalArgumentException("Height value can't be bigger than the y-radius");
        }
        Optional<Double> area = EllipseSegModel.calculateArea(xRadius, yRadius, height);
        if (!area.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(new EllipseSegModel(area.get(), xRadius, yRadius, height));
    }

    private static Optional<Double> calculateArea(double xRadius, double yRadius, double height) {
        double mult = xRadius * yRadius / 2.0;
        if (Double.isInfinite(mult)) {
            return Optional.empty();
        }
        double heightSquaredTimesFour = 4.0 * height * height;
        if (Double.isInfinite(heightSquaredTimesFour)) {
            return Optional.empty();
        }
        double ySquared = yRadius * yRadius;
        if (Double.isInfinite(ySquared)) {
            return Optional.empty();
        }
        double acos = Math.acos(1.0 - 2.0 * height / yRadius);
        double sqrtMult = 1.0 - 2.0 * height / yRadius;
        double sqrt = Math.sqrt(4.0 * height / yRadius - heightSquaredTimesFour / ySquared);
        return Optional.of(mult * (acos - sqrtMult * sqrt));
    }

    private EllipseSegModel(double area, double xRadius, double yRadius, double height) {
        super(area);
        this.xRadius = xRadius;
        this.yRadius = yRadius;
        this.height = height;
        this.top = Vec.create(Dimension.TWO, 0.0, height);
        this.left = Vec.create(Dimension.TWO, -xRadius, 0.0);
        this.right = Vec.create(Dimension.TWO, xRadius, 0.0);
    }

    @Override
    protected boolean isPointOnModel(Vec<Two> point) {
        if (!RoundingHelper.areValuesAlmostEqual(point.getElement(1), 0.0) && point.getElement(1) < 0.0) {
            return false;
        }
        if (!RoundingHelper.areValuesAlmostEqual(point.getElement(1), this.height) && point.getElement(1) > this.height) {
            return false;
        }
        double centerYOffset = this.yRadius - this.height;
        Vec<Two> newPoint = Vec.create(Dimension.TWO, point.getElement(0), point.getElement(1) + centerYOffset);
        double neededX = Math.abs(Math.cos(newPoint.getElement(1) / this.yRadius) * this.xRadius);
        return RoundingHelper.areValuesAlmostEqual(neededX, newPoint.getElement(0)) || point.getElement(0) <= neededX;
    }

    @Override
    public boolean resembles(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof EllipseSegModel) {
            EllipseSegModel m = (EllipseSegModel)o;
            return RoundingHelper.areValuesAlmostEqual(m.getXRadius(), this.xRadius) && RoundingHelper.areValuesAlmostEqual(m.getYRadius(), this.yRadius) && RoundingHelper.areValuesAlmostEqual(m.getHeight(), this.height);
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof EllipseSegModel) {
            EllipseSegModel m = (EllipseSegModel)o;
            return m.xRadius == this.xRadius && m.yRadius == this.yRadius && m.height == this.height;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 3 * Double.hashCode(this.xRadius) + 5 * Double.hashCode(this.yRadius) + 7 * Double.hashCode(this.height);
    }

    @Override
    public String toString() {
        return "ellipse segment model: {x-radius=" + this.xRadius + ", y-radius=" + this.yRadius + ", height: " + this.height + ", area=" + this.getArea() + "}";
    }

    public double getXRadius() {
        return this.xRadius;
    }

    public double getYRadius() {
        return this.yRadius;
    }

    public double getHeight() {
        return this.height;
    }

    public Vec<Two> getTop() {
        return this.top;
    }

    public Vec<Two> getLeft() {
        return this.left;
    }

    public Vec<Two> getRight() {
        return this.right;
    }
}

