/*
 * Decompiled with CFR 0.152.
 */
package org.monospark.geometrix.shape.flat.ellipseseg;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.monospark.geometrix.dimensions.TwoMin;
import org.monospark.geometrix.shape.flat.FlatShape;
import org.monospark.geometrix.shape.flat.alignment.Alignment;
import org.monospark.geometrix.shape.flat.ellipseseg.EllipseSegModel;
import org.monospark.geometrix.util.ListHelper;
import org.monospark.geometrix.vector.Vec;
import org.monospark.geometrix.vector.VecHelper;

public final class EllipseSeg<D extends TwoMin, A extends Alignment<D>>
extends FlatShape<EllipseSegModel, D, A> {
    private final Vec<D> center;
    private final Vec<D> xAxis;
    private final Vec<D> yAxis;
    private final Vec<D> top;
    private final Vec<D> right;
    private final Vec<D> left;

    public static <D extends TwoMin, A extends Alignment<D>> EllipseSeg<D, A> create(EllipseSegModel model, A alignment) {
        return EllipseSeg.createOptional(model, alignment).orElseThrow(() -> new IllegalArgumentException("Resulting ellipse does not lie completely inside of the object space"));
    }

    public static <D extends TwoMin, A extends Alignment<D>> Optional<EllipseSeg<D, A>> createOptional(EllipseSegModel model, A alignment) {
        double majorRadius;
        Objects.requireNonNull(model, "Model must be not null");
        Objects.requireNonNull(alignment, "Alignment must be not null");
        Vec<D> center = alignment.getGlobalPoint(Vec.two(0.0, 0.0));
        Vec<D> xAxis = alignment.getGlobalDirection(Vec.two(1.0, 0.0));
        Vec<D> yAxis = alignment.getGlobalDirection(Vec.two(0.0, 1.0));
        double d = majorRadius = model.getXRadius() > model.getYRadius() ? model.getXRadius() : model.getYRadius();
        if (VecHelper.calculateLength(center) + majorRadius >= 8.988465674311579E307) {
            return Optional.empty();
        }
        return Optional.of(new EllipseSeg<D, A>(model, alignment, center, xAxis, yAxis));
    }

    public EllipseSeg(EllipseSegModel model, A alignment, Vec<D> center, Vec<D> xAxis, Vec<D> yAxis) {
        super(model, alignment);
        this.center = center;
        this.xAxis = xAxis;
        this.yAxis = yAxis;
        this.top = VecHelper.add(center, VecHelper.multiply(yAxis, model.getYRadius()));
        this.right = VecHelper.add(center, VecHelper.multiply(xAxis, model.getXRadius()));
        this.left = VecHelper.add(center, VecHelper.multiply(xAxis, -model.getXRadius()));
    }

    @Override
    public boolean resembles(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof EllipseSeg) {
            EllipseSeg e = (EllipseSeg)o;
            List<Vec> ePoints = Arrays.asList(e.top, e.right, e.left);
            List<Vec> points = Arrays.asList(this.top, this.right, this.left);
            return ListHelper.areListContentOrdersEqual(ePoints, points, (v1, v2) -> v1.resembles(v2));
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof EllipseSeg) {
            EllipseSeg e = (EllipseSeg)o;
            return e.center.equals(this.center) && e.xAxis.equals(this.xAxis) && e.yAxis.equals(this.yAxis) && ((EllipseSegModel)e.model).equals(this.model);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 3 * this.center.hashCode() + 5 * this.xAxis.hashCode() + 7 * this.yAxis.hashCode() + 11 * ((EllipseSegModel)this.model).hashCode();
    }

    @Override
    public String toString() {
        return "ellipse segment: {center=" + this.center + ", x-axis=" + this.xAxis + ", y-axis=" + this.yAxis + ", model=" + ((EllipseSegModel)this.model).toString() + "}";
    }

    public Vec<D> getCenter() {
        return this.center;
    }

    public Vec<D> getXAxis() {
        return this.xAxis;
    }

    public Vec<D> getYAxis() {
        return this.yAxis;
    }

    public Vec<D> getTopPoint() {
        return this.top;
    }

    public Vec<D> getRightEndPoint() {
        return this.right;
    }

    public Vec<D> getLeftEndPoint() {
        return this.left;
    }
}

