/*
 * Decompiled with CFR 0.152.
 */
package org.monospark.geometrix.shape.flat.ellipse;

import java.util.Optional;
import org.monospark.geometrix.dimensions.Two;
import org.monospark.geometrix.shape.flat.FlatShapeModel;
import org.monospark.geometrix.util.RoundingHelper;
import org.monospark.geometrix.vector.Vec;

public final class EllipseModel
extends FlatShapeModel {
    private final double xRadius;
    private final double yRadius;

    public static EllipseModel createCircle(double radius) {
        return EllipseModel.create(radius, radius);
    }

    public static Optional<EllipseModel> createCircleOptional(double radius) {
        return EllipseModel.createOptional(radius, radius);
    }

    public static EllipseModel create(double xRadius, double yRadius) {
        return EllipseModel.createOptional(xRadius, yRadius).orElseThrow(() -> new IllegalArgumentException("The are of the ellipse model is infinite"));
    }

    public static Optional<EllipseModel> createOptional(double xRadius, double yRadius) {
        if (Double.isInfinite(xRadius) || Double.isNaN(xRadius) || xRadius <= 0.0) {
            throw new IllegalArgumentException("Invalid x-radius: " + xRadius);
        }
        if (Double.isInfinite(yRadius) || Double.isNaN(yRadius) || yRadius <= 0.0) {
            throw new IllegalArgumentException("Invalid y-radius: " + yRadius);
        }
        double area = Math.PI * xRadius * yRadius;
        if (Double.isInfinite(area)) {
            return Optional.empty();
        }
        return Optional.of(new EllipseModel(area, xRadius, yRadius));
    }

    private EllipseModel(double area, double xRadius, double yRadius) {
        super(area);
        this.xRadius = xRadius;
        this.yRadius = yRadius;
    }

    @Override
    protected boolean isPointOnModel(Vec<Two> point) {
        if (!RoundingHelper.areValuesAlmostEqual(point.getElement(1), -this.yRadius) && point.getElement(1) < -this.yRadius) {
            return false;
        }
        if (!RoundingHelper.areValuesAlmostEqual(point.getElement(1), this.yRadius) && point.getElement(1) > this.yRadius) {
            return false;
        }
        double neededX = Math.abs(Math.cos(point.getElement(1) / this.yRadius) * this.xRadius);
        return RoundingHelper.areValuesAlmostEqual(neededX, point.getElement(0)) || point.getElement(0) <= neededX;
    }

    @Override
    public boolean resembles(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof EllipseModel) {
            EllipseModel m = (EllipseModel)o;
            return RoundingHelper.areValuesAlmostEqual(m.xRadius, this.xRadius) && RoundingHelper.areValuesAlmostEqual(m.yRadius, this.yRadius);
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof EllipseModel) {
            EllipseModel m = (EllipseModel)o;
            return m.xRadius == this.xRadius && m.yRadius == this.yRadius;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 13 * Double.hashCode(this.xRadius) + 31 * Double.hashCode(this.yRadius);
    }

    @Override
    public String toString() {
        return "ellipse model: {x-radius=" + this.xRadius + ", y-radius=" + this.yRadius + ", area=" + this.getArea() + "}";
    }

    public double getXRadius() {
        return this.xRadius;
    }

    public double getYRadius() {
        return this.yRadius;
    }
}

