/*
 * Decompiled with CFR 0.152.
 */
package org.monospark.geometrix.shape.flat.ellipse;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.monospark.geometrix.dimensions.Dimension;
import org.monospark.geometrix.dimensions.TwoMin;
import org.monospark.geometrix.shape.flat.FlatShape;
import org.monospark.geometrix.shape.flat.alignment.Alignment;
import org.monospark.geometrix.shape.flat.ellipse.EllipseModel;
import org.monospark.geometrix.util.ListHelper;
import org.monospark.geometrix.vector.Vec;
import org.monospark.geometrix.vector.VecHelper;

public class Ellipse<D extends TwoMin, A extends Alignment<D>>
extends FlatShape<EllipseModel, D, A> {
    private final Vec<D> center;
    private final Vec<D> xAxis;
    private final Vec<D> yAxis;
    private final Vec<D> top;
    private final Vec<D> bottom;
    private final Vec<D> right;
    private final Vec<D> left;

    public static <D extends TwoMin, A extends Alignment<D>> Ellipse<D, A> create(EllipseModel model, A alignment) {
        return Ellipse.createOptional(model, alignment).orElseThrow(() -> new IllegalArgumentException("Resulting ellipse does not lie completely inside of the object space"));
    }

    public static <D extends TwoMin, A extends Alignment<D>> Optional<Ellipse<D, A>> createOptional(EllipseModel model, A alignment) {
        double majorRadius;
        Objects.requireNonNull(model, "Model must be not null");
        Objects.requireNonNull(alignment, "Alignment must be not null");
        Vec<D> center = alignment.getGlobalPoint(Vec.zero(Dimension.TWO));
        Vec<D> xAxis = alignment.getGlobalDirection(Vec.two(1.0, 0.0));
        Vec<D> yAxis = alignment.getGlobalDirection(Vec.two(0.0, 1.0));
        double d = majorRadius = model.getXRadius() > model.getYRadius() ? model.getXRadius() : model.getYRadius();
        if (VecHelper.calculateLength(center) + majorRadius >= 8.988465674311579E307) {
            return Optional.empty();
        }
        return Optional.of(new Ellipse<D, A>(model, alignment, center, xAxis, yAxis));
    }

    public Ellipse(EllipseModel model, A alignment, Vec<D> center, Vec<D> xAxis, Vec<D> yAxis) {
        super(model, alignment);
        this.center = center;
        this.xAxis = xAxis;
        this.yAxis = yAxis;
        this.top = VecHelper.add(center, VecHelper.multiply(yAxis, model.getYRadius()));
        this.bottom = VecHelper.add(center, VecHelper.multiply(yAxis, -model.getYRadius()));
        this.right = VecHelper.add(center, VecHelper.multiply(xAxis, model.getXRadius()));
        this.left = VecHelper.add(center, VecHelper.multiply(xAxis, -model.getXRadius()));
    }

    @Override
    public boolean resembles(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof Ellipse) {
            Ellipse e = (Ellipse)o;
            List<Vec> ePoints = Arrays.asList(e.top, e.bottom, e.right, e.left);
            List<Vec> points = Arrays.asList(this.top, this.bottom, this.right, this.left);
            return ListHelper.areListContentOrdersEqual(ePoints, points, (v1, v2) -> v1.resembles(v2));
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof Ellipse) {
            Ellipse e = (Ellipse)o;
            return e.center.equals(this.center) && e.xAxis.equals(this.xAxis) && e.yAxis.equals(this.yAxis) && ((EllipseModel)e.model).equals(this.model);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 13 * this.center.hashCode() + 31 * this.xAxis.hashCode() + 13 * this.yAxis.hashCode() + 31 * ((EllipseModel)this.model).hashCode();
    }

    @Override
    public String toString() {
        return "ellipse: {center=" + this.center + ", x-axis=" + this.xAxis + ", y-axis=" + this.yAxis + ", model=" + ((EllipseModel)this.model).toString() + "}";
    }

    public Vec<D> getCenter() {
        return this.center;
    }

    public Vec<D> getXAxis() {
        return this.xAxis;
    }

    public Vec<D> getYAxis() {
        return this.yAxis;
    }

    public Vec<D> getTopPoint() {
        return this.top;
    }

    public Vec<D> getBottomPoint() {
        return this.bottom;
    }

    public Vec<D> getRightPoint() {
        return this.right;
    }

    public Vec<D> getLeftPoint() {
        return this.left;
    }
}

