/*
 * Decompiled with CFR 0.152.
 */
package org.monospark.geometrix.shape.flat.alignment;

import java.util.Objects;
import org.monospark.geometrix.dimensions.Dimension;
import org.monospark.geometrix.dimensions.Three;
import org.monospark.geometrix.dimensions.Two;
import org.monospark.geometrix.plane.PlaneCoordinateSystem;
import org.monospark.geometrix.shape.flat.alignment.Alignment;
import org.monospark.geometrix.vector.Vec;

public final class PlaneAlignment
extends Alignment<Three> {
    private final PlaneCoordinateSystem coordinateSystem;

    public PlaneAlignment(PlaneCoordinateSystem coordinateSystem) {
        super(Dimension.THREE);
        Objects.requireNonNull(coordinateSystem, "Coordinate system must be not null");
        this.coordinateSystem = coordinateSystem;
    }

    @Override
    public Vec<Two> getLocalPoint(Vec<Three> point) {
        return this.coordinateSystem.getLocalPoint(point);
    }

    @Override
    public Vec<Three> getGlobalPoint(Vec<Two> point) {
        return this.coordinateSystem.getGlobalPoint(point);
    }

    @Override
    public Vec<Two> getLocalDirection(Vec<Three> direction) {
        return this.coordinateSystem.getLocalDirection(direction);
    }

    @Override
    public Vec<Three> getGlobalDirection(Vec<Two> direction) {
        return this.coordinateSystem.getGlobalDirection(direction);
    }

    @Override
    public boolean resembles(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof PlaneAlignment) {
            PlaneAlignment a = (PlaneAlignment)o;
            return a.coordinateSystem.resembles(this.coordinateSystem);
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof PlaneAlignment) {
            PlaneAlignment a = (PlaneAlignment)o;
            return a.coordinateSystem.equals(this.coordinateSystem);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 31 * this.coordinateSystem.hashCode();
    }

    @Override
    public String toString() {
        return "plane alignment: {coordinate system: " + this.coordinateSystem + "}";
    }
}

