/*
 * Decompiled with CFR 0.152.
 */
package org.monospark.geometrix.shape.flat.alignment;

import java.util.Objects;
import org.monospark.geometrix.dimensions.Dimension;
import org.monospark.geometrix.dimensions.Two;
import org.monospark.geometrix.shape.flat.alignment.Alignment;
import org.monospark.geometrix.util.RoundingHelper;
import org.monospark.geometrix.vector.Vec;
import org.monospark.geometrix.vector.VecHelper;

public final class FlatAlignment
extends Alignment<Two> {
    public static final FlatAlignment NO_ALIGNMENT = new FlatAlignment(Vec.create(Dimension.TWO, 0.0, 0.0), 0.0);
    private final Vec<Two> translation;
    private final double rotation;

    public FlatAlignment(Vec<Two> translation, double rotation) {
        super(Dimension.TWO);
        Objects.requireNonNull(translation, "Translation vector must be not null");
        if (!Vec.isInObjectSpace(translation)) {
            throw new IllegalArgumentException("Translation vector must lie inside the object space");
        }
        if (Double.isInfinite(rotation) || Double.isNaN(rotation)) {
            throw new IllegalArgumentException("Invalid rotation value: " + rotation);
        }
        this.translation = translation;
        this.rotation = rotation;
    }

    @Override
    public Vec<Two> getLocalPoint(Vec<Two> point) {
        Objects.requireNonNull(point, "Global point can't be null");
        if (!Vec.isInObjectSpace(point)) {
            throw new IllegalArgumentException("Global point must lie inside the object space");
        }
        return VecHelper.subtract(point, this.translation);
    }

    @Override
    public Vec<Two> getGlobalPoint(Vec<Two> point) {
        Objects.requireNonNull(point, "Local point can't be null");
        if (!Vec.isInObjectSpace(point)) {
            throw new IllegalArgumentException("Local point must lie inside the object space");
        }
        return VecHelper.add(this.rotatePoint(point, this.rotation), this.translation);
    }

    @Override
    public Vec<Two> getLocalDirection(Vec<Two> direction) {
        Objects.requireNonNull(direction, "Global direction can't be null");
        return this.rotatePoint(direction, -this.rotation);
    }

    @Override
    public Vec<Two> getGlobalDirection(Vec<Two> direction) {
        Objects.requireNonNull(direction, "Local direction can't be null");
        return this.rotatePoint(direction, this.rotation);
    }

    private Vec<Two> rotatePoint(Vec<Two> point, double rot) {
        double rad = Math.toRadians(rot);
        double nx = Math.cos(rad) * point.getElement(0) - Math.sin(rad) * point.getElement(1);
        double ny = Math.sin(rad) * point.getElement(0) + Math.cos(rad) * point.getElement(1);
        return Vec.two(nx, ny);
    }

    @Override
    public boolean resembles(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof FlatAlignment) {
            FlatAlignment a = (FlatAlignment)o;
            return a.translation.resembles(this.translation) && RoundingHelper.areValuesAlmostEqual(a.rotation, this.rotation);
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof FlatAlignment) {
            FlatAlignment a = (FlatAlignment)o;
            return a.translation.equals(this.translation) && a.rotation == this.rotation;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 13 * this.translation.hashCode() + 31 * Double.hashCode(this.rotation);
    }

    @Override
    public String toString() {
        return "flat alignment: {translation: " + this.translation + ", rotation: " + this.rotation + "}";
    }
}

