/*
 * Decompiled with CFR 0.152.
 */
package org.monospark.geometrix.shape.flat;

import java.util.Objects;
import org.monospark.geometrix.GeometrixObject;
import org.monospark.geometrix.dimensions.Two;
import org.monospark.geometrix.dimensions.TwoMin;
import org.monospark.geometrix.shape.flat.FlatShapeModel;
import org.monospark.geometrix.shape.flat.alignment.Alignment;
import org.monospark.geometrix.vector.Vec;

public abstract class FlatShape<M extends FlatShapeModel, D extends TwoMin, A extends Alignment<D>>
extends GeometrixObject {
    protected final M model;
    protected final A alignment;

    public FlatShape(M model, A alignment) {
        this.model = model;
        this.alignment = alignment;
    }

    public final boolean isPointOnModel(Vec<D> point) {
        Objects.requireNonNull(point, "Point must be not null");
        Vec<Two> local = ((Alignment)this.alignment).getLocalPoint(point);
        if (!Vec.isInObjectSpace(local)) {
            return false;
        }
        return ((FlatShapeModel)this.model).isPointOnModel(local);
    }

    public final M getModel() {
        return this.model;
    }

    public final A getAlignment() {
        return this.alignment;
    }

    public final D getDimension() {
        return ((Alignment)this.alignment).getDimension();
    }
}

