/*
 * Decompiled with CFR 0.152.
 */
package org.monospark.geometrix.rotation;

import java.util.Objects;
import java.util.Optional;
import org.monospark.geometrix.dimensions.Three;
import org.monospark.geometrix.matrix.Mat;
import org.monospark.geometrix.rotation.Rotation;
import org.monospark.geometrix.vector.Vec;
import org.monospark.geometrix.vector.VecHelper;

public final class RotationHelper {
    private RotationHelper() {
    }

    public static Vec<Three> rotatePoint(Vec<Three> point, Vec<Three> center, Rotation rot) {
        Optional<Vec<Three>> rotated = RotationHelper.rotatePointOptional(point, center, rot);
        if (rotated.isPresent()) {
            return rotated.get();
        }
        throw new IllegalArgumentException("Rotated vector is outside of the vector space");
    }

    public static Optional<Vec<Three>> rotatePointOptional(Vec<Three> point, Vec<Three> center, Rotation rot) {
        Objects.requireNonNull(point, "Point can't be null");
        Objects.requireNonNull(center, "Center can't be null");
        Objects.requireNonNull(rot, "Rotation can't be null");
        Mat<Three, Three> rotMat = rot.getRotationMatrix();
        Vec<Three> relativePoint = VecHelper.subtract(point, center);
        Optional<Vec<Three>> rotatedPointResult = VecHelper.multiplyOptional(relativePoint, rotMat);
        if (!rotatedPointResult.isPresent()) {
            return Optional.empty();
        }
        Vec<Three> rotatedPoint = rotatedPointResult.get();
        Optional<Vec<Three>> addRotatedPointResult = VecHelper.addOptional(center, rotatedPoint);
        if (!addRotatedPointResult.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(addRotatedPointResult.get());
    }
}

