/*
 * Decompiled with CFR 0.152.
 */
package org.monospark.geometrix.rotation;

import java.util.Objects;
import org.monospark.geometrix.rotation.Quaternion;

public final class QuaternionHelper {
    private QuaternionHelper() {
    }

    public static Quaternion calculateQuaternionDifference(Quaternion qStart, Quaternion qEnd) {
        Objects.requireNonNull(qStart, "Start quaternion can't be null");
        Objects.requireNonNull(qStart, "End quaternion can't be null");
        return QuaternionHelper.multiply(qEnd, QuaternionHelper.inverse(qStart));
    }

    public static Quaternion inverse(Quaternion q) {
        Objects.requireNonNull(q, "Quaternion can't be null");
        return new Quaternion(-q.getX(), -q.getY(), -q.getZ(), q.getW());
    }

    public static Quaternion multiply(Quaternion q1, Quaternion q2) {
        Objects.requireNonNull(q1, "First quaternion can't be null");
        Objects.requireNonNull(q2, "Second quaternion can't be null");
        double nx = q1.getX() * q2.getW() + q1.getY() * q2.getZ() - q1.getZ() * q2.getY() + q1.getW() * q2.getX();
        double ny = -(q1.getX() * q2.getZ()) + q1.getY() * q2.getW() + q1.getZ() * q2.getX() + q1.getW() * q2.getY();
        double nz = q1.getX() * q2.getY() - q1.getY() * q2.getX() + q1.getZ() * q2.getW() + q1.getW() * q2.getZ();
        double nw = -(q1.getX() * q2.getX()) - q1.getY() * q2.getY() - q1.getZ() * q2.getZ() + q1.getW() * q2.getW();
        return new Quaternion(nx, ny, nz, nw);
    }
}

