/*
 * Decompiled with CFR 0.152.
 */
package org.monospark.geometrix.rotation;

import java.util.Objects;
import org.monospark.geometrix.dimensions.Dimension;
import org.monospark.geometrix.dimensions.Three;
import org.monospark.geometrix.matrix.Mat;
import org.monospark.geometrix.rotation.AxisAngle;
import org.monospark.geometrix.rotation.Rotation;
import org.monospark.geometrix.util.RoundingHelper;
import org.monospark.geometrix.vector.Vec;
import org.monospark.geometrix.vector.VecHelper;

public final class Quaternion
extends Rotation {
    public static final Quaternion NO_ROTATION = new Quaternion(0.0, 0.0, 0.0, 1.0);
    public static final Quaternion X_90 = new Quaternion(Vec.create(Dimension.THREE, 1.0, 0.0, 0.0), 90.0);
    public static final Quaternion X_180 = new Quaternion(Vec.create(Dimension.THREE, 1.0, 0.0, 0.0), 180.0);
    public static final Quaternion X_270 = new Quaternion(Vec.create(Dimension.THREE, 1.0, 0.0, 0.0), 270.0);
    public static final Quaternion Y_90 = new Quaternion(Vec.create(Dimension.THREE, 0.0, 1.0, 0.0), 90.0);
    public static final Quaternion Y_180 = new Quaternion(Vec.create(Dimension.THREE, 0.0, 1.0, 0.0), 180.0);
    public static final Quaternion Y_270 = new Quaternion(Vec.create(Dimension.THREE, 0.0, 1.0, 0.0), 270.0);
    public static final Quaternion Z_90 = new Quaternion(Vec.create(Dimension.THREE, 0.0, 0.0, 1.0), 90.0);
    public static final Quaternion Z_180 = new Quaternion(Vec.create(Dimension.THREE, 0.0, 0.0, 1.0), 180.0);
    public static final Quaternion Z_270 = new Quaternion(Vec.create(Dimension.THREE, 0.0, 0.0, 1.0), 270.0);
    private final double x;
    private final double y;
    private final double z;
    private final double w;

    public static Quaternion create(Vec<Three> axis, double angle) {
        Objects.requireNonNull(axis, "Rotation axis can't be null");
        if (Vec.isZeroVec(axis)) {
            throw new IllegalArgumentException("Axis vector must not be a zero vector");
        }
        if (Double.isInfinite(angle) || Double.isNaN(angle)) {
            throw new IllegalArgumentException("Invalid rotation angle: " + angle);
        }
        Vec<Three> normalizedAxis = VecHelper.normalize(axis);
        return new Quaternion(normalizedAxis, angle);
    }

    public static Quaternion createFromAxisAngle(AxisAngle aa) {
        Objects.requireNonNull(aa, "Axis-angle can't be null");
        return new Quaternion(aa.getAxis(), aa.getAngle());
    }

    Quaternion(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    private Quaternion(Vec<Three> axis, double angle) {
        double rad = Math.toRadians(angle);
        this.x = axis.getElement(0) * Math.sin(rad / 2.0);
        this.y = axis.getElement(1) * Math.sin(rad / 2.0);
        this.z = axis.getElement(2) * Math.sin(rad / 2.0);
        this.w = Math.cos(rad / 2.0);
    }

    @Override
    protected Mat<Three, Three> createRotationMatrix() {
        return Mat.create(Dimension.THREE, Dimension.THREE, Mat.ElementOrder.ROW_MAJOR, 1.0 - 2.0 * (this.y * this.y) - 2.0 * (this.z * this.z), 2.0 * this.x * this.y - 2.0 * this.z * this.w, 2.0 * this.x * this.z + 2.0 * this.y * this.w, 2.0 * this.x * this.y + 2.0 * this.z * this.w, 1.0 - 2.0 * (this.x * this.x) - 2.0 * (this.z * this.z), 2.0 * this.y * this.z - 2.0 * this.x * this.w, 2.0 * this.x * this.z - 2.0 * this.y * this.w, 2.0 * this.y * this.z + 2.0 * this.x * this.w, 1.0 - 2.0 * (this.x * this.x) - 2.0 * (this.y * this.y));
    }

    @Override
    public boolean resembles(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof Quaternion) {
            Quaternion q = (Quaternion)o;
            if (RoundingHelper.areValuesAlmostEqual(q.x, this.x) && RoundingHelper.areValuesAlmostEqual(q.y, this.y) && RoundingHelper.areValuesAlmostEqual(q.z, this.z) && RoundingHelper.areValuesAlmostEqual(q.w, this.w)) {
                return true;
            }
            return RoundingHelper.areValuesAlmostEqual(q.x, -this.x) && RoundingHelper.areValuesAlmostEqual(q.y, -this.y) && RoundingHelper.areValuesAlmostEqual(q.z, -this.z) && RoundingHelper.areValuesAlmostEqual(q.w, -this.w);
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof Quaternion) {
            Quaternion q = (Quaternion)o;
            return q.x == this.x && q.y == this.y && q.z == this.z && q.w == this.w;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 3 * Double.hashCode(this.x) + 5 * Double.hashCode(this.y) + 7 * Double.hashCode(this.z) + 11 * Double.hashCode(this.w);
    }

    @Override
    public String toString() {
        return "quaternion: {x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", w=" + this.w + "}";
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getW() {
        return this.w;
    }
}

