/*
 * Decompiled with CFR 0.152.
 */
package org.monospark.geometrix.rotation;

import java.util.Objects;
import org.monospark.geometrix.dimensions.Dimension;
import org.monospark.geometrix.dimensions.Three;
import org.monospark.geometrix.matrix.Mat;
import org.monospark.geometrix.rotation.Quaternion;
import org.monospark.geometrix.rotation.Rotation;
import org.monospark.geometrix.util.RoundingHelper;
import org.monospark.geometrix.vector.Vec;
import org.monospark.geometrix.vector.VecHelper;

public final class AxisAngle
extends Rotation {
    public static final AxisAngle X_0 = new AxisAngle(Vec.create(Dimension.THREE, 1.0, 0.0, 0.0), 0.0);
    public static final AxisAngle X_90 = new AxisAngle(Vec.create(Dimension.THREE, 1.0, 0.0, 0.0), 90.0);
    public static final AxisAngle X_180 = new AxisAngle(Vec.create(Dimension.THREE, 1.0, 0.0, 0.0), 180.0);
    public static final AxisAngle X_270 = new AxisAngle(Vec.create(Dimension.THREE, 1.0, 0.0, 0.0), 270.0);
    public static final AxisAngle Y_0 = new AxisAngle(Vec.create(Dimension.THREE, 0.0, 1.0, 0.0), 0.0);
    public static final AxisAngle Y_90 = new AxisAngle(Vec.create(Dimension.THREE, 0.0, 1.0, 0.0), 90.0);
    public static final AxisAngle Y_180 = new AxisAngle(Vec.create(Dimension.THREE, 0.0, 1.0, 0.0), 180.0);
    public static final AxisAngle Y_270 = new AxisAngle(Vec.create(Dimension.THREE, 0.0, 1.0, 0.0), 270.0);
    public static final AxisAngle Z_0 = new AxisAngle(Vec.create(Dimension.THREE, 0.0, 0.0, 1.0), 0.0);
    public static final AxisAngle Z_90 = new AxisAngle(Vec.create(Dimension.THREE, 0.0, 0.0, 1.0), 90.0);
    public static final AxisAngle Z_180 = new AxisAngle(Vec.create(Dimension.THREE, 0.0, 0.0, 1.0), 180.0);
    public static final AxisAngle Z_270 = new AxisAngle(Vec.create(Dimension.THREE, 0.0, 0.0, 1.0), 270.0);
    private final Vec<Three> axis;
    private final double angle;

    public static AxisAngle create(Vec<Three> axis, double angle) {
        Objects.requireNonNull(axis, "Rotation axis can't be null");
        if (Vec.isZeroVec(axis)) {
            throw new IllegalArgumentException("Axis vector must not be a zero vector");
        }
        if (Double.isInfinite(angle) || Double.isNaN(angle)) {
            throw new IllegalArgumentException("Invalid rotation angle: " + angle);
        }
        Vec<Three> normalizedAxis = VecHelper.normalize(axis);
        return new AxisAngle(normalizedAxis, angle);
    }

    public static AxisAngle createFromQuaternion(Quaternion q) {
        Objects.requireNonNull(q, "Quaternion can't be null");
        double sqrtValue = 1.0 - q.getW() * q.getW();
        if (sqrtValue == 0.0) {
            return Y_0;
        }
        double angle = Math.toDegrees(2.0 * Math.acos(q.getW()));
        double div = Math.sqrt(sqrtValue);
        double x = q.getX() / div;
        double y = q.getY() / div;
        double z = q.getZ() / div;
        Vec<Three> direc = Vec.create(Dimension.THREE, x, y, z);
        return new AxisAngle(direc, angle);
    }

    private AxisAngle(Vec<Three> axis, double angle) {
        this.axis = axis;
        this.angle = angle;
    }

    @Override
    protected Mat<Three, Three> createRotationMatrix() {
        double c = Math.cos(Math.toRadians(this.angle));
        double s = Math.sin(Math.toRadians(this.angle));
        double t = 1.0 - c;
        double x = this.axis.getElement(0);
        double y = this.axis.getElement(1);
        double z = this.axis.getElement(2);
        return Mat.create(Dimension.THREE, Dimension.THREE, Mat.ElementOrder.ROW_MAJOR, t * x * x + c, t * x * y - z * s, t * x * z + y * s, t * x * y + z * s, t * y * y + c, t * y * z - x * s, t * x * z - y * s, t * y * z + x * z, t * z * z + c);
    }

    @Override
    public boolean resembles(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof AxisAngle) {
            boolean sameValues;
            AxisAngle a = (AxisAngle)o;
            double angle1 = a.angle > 0.0 ? a.angle % 360.0 : a.angle % -360.0 + 360.0;
            double angle2 = this.angle > 0.0 ? this.angle % 360.0 : this.angle % -360.0 + 360.0;
            boolean bl = sameValues = a.axis.resembles(this.axis) && RoundingHelper.areValuesAlmostEqual(angle1, angle2);
            if (sameValues) {
                return true;
            }
            boolean reversed = a.axis.resembles(VecHelper.negate(this.axis)) && RoundingHelper.areValuesAlmostEqual(angle1, 360.0 - angle2);
            return reversed;
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof AxisAngle) {
            AxisAngle a = (AxisAngle)o;
            return a.axis.equals(this.axis) && a.angle == this.angle;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 13 * this.axis.hashCode() + 31 * Double.hashCode(this.angle);
    }

    @Override
    public String toString() {
        return "axis-angle: {axis=" + this.axis.toString() + ", angle=" + this.angle + "}";
    }

    public Vec<Three> getAxis() {
        return this.axis;
    }

    public double getAngle() {
        return this.angle;
    }
}

