/*
 * Decompiled with CFR 0.152.
 */
package org.monospark.geometrix.plane;

import java.util.Objects;
import java.util.Optional;
import org.monospark.geometrix.dimensions.Three;
import org.monospark.geometrix.dimensions.ThreeMin;
import org.monospark.geometrix.line.Line;
import org.monospark.geometrix.plane.Plane;
import org.monospark.geometrix.util.RoundingHelper;
import org.monospark.geometrix.vector.Vec;
import org.monospark.geometrix.vector.VecHelper;

public final class PlaneHelper {
    private PlaneHelper() {
    }

    public static <D extends ThreeMin> boolean isPointOnPlane(Plane plane, Vec<Three> point) {
        Objects.requireNonNull(plane, "Plane can't be null");
        Objects.requireNonNull(point, "Point can't be null");
        if (!Vec.isInObjectSpace(point)) {
            throw new IllegalArgumentException("Point must lie inside the object space");
        }
        Vec<Three> toPoint = VecHelper.subtract(point, plane.getInitialPoint());
        if (Vec.isZeroVec(toPoint)) {
            return true;
        }
        Vec<Three> vecComponent = VecHelper.calculateVectorComponent(plane.getNormal(), toPoint);
        double length = VecHelper.calculateLength(vecComponent);
        return RoundingHelper.areValuesAlmostEqual(length, 0.0);
    }

    public static <D extends ThreeMin> Optional<Vec<Three>> calculateIntersectionPoint(Plane p, Line<Three> l) {
        double denominator;
        Objects.requireNonNull(p, "Plane can't be null");
        Objects.requireNonNull(l, "Line can't be null");
        if (PlaneHelper.isLineParallelToPlane(p, l)) {
            return Optional.empty();
        }
        boolean onPlane = PlaneHelper.isPointOnPlane(p, l.getInitialPoint());
        if (onPlane) {
            return Optional.of(l.getInitialPoint());
        }
        double nominator = VecHelper.dot(VecHelper.subtract(p.getInitialPoint(), l.getInitialPoint()), p.getNormal());
        double d = nominator / (denominator = VecHelper.dot(l.getDirection(), p.getNormal()));
        if (Double.isInfinite(d)) {
            return Optional.empty();
        }
        Optional<Vec<Three>> directionMultResult = VecHelper.multiplyOptional(l.getDirection(), d);
        if (!directionMultResult.isPresent()) {
            return Optional.empty();
        }
        Vec<Three> directionMult = directionMultResult.get();
        Optional<Vec<Three>> interPointResult = VecHelper.addOptional(l.getInitialPoint(), directionMult);
        return interPointResult;
    }

    public static <D extends ThreeMin> boolean isLineParallelToPlane(Plane p, Line<Three> l) {
        Objects.requireNonNull(p, "Plane can't be null");
        Objects.requireNonNull(l, "Line can't be null");
        return RoundingHelper.areValuesAlmostEqual(VecHelper.dot(p.getNormal(), l.getDirection()), 0.0);
    }

    public static <D extends ThreeMin> boolean isLineOnPlane(Plane p, Line<Three> l) {
        Objects.requireNonNull(p, "Plane can't be null");
        Objects.requireNonNull(l, "Line can't be null");
        boolean parallel = PlaneHelper.isLineParallelToPlane(p, l);
        if (!parallel) {
            return false;
        }
        return PlaneHelper.isPointOnPlane(p, l.getInitialPoint());
    }
}

