/*
 * Decompiled with CFR 0.152.
 */
package org.monospark.geometrix.plane;

import java.util.Objects;
import org.monospark.geometrix.GeometrixObject;
import org.monospark.geometrix.dimensions.Three;
import org.monospark.geometrix.dimensions.Two;
import org.monospark.geometrix.plane.Plane;
import org.monospark.geometrix.vector.Vec;
import org.monospark.geometrix.vector.VecHelper;

public final class PlaneCoordinateSystem
extends GeometrixObject {
    private final Plane plane;
    private final Vec<Three> center;
    private final Vec<Three> xAxis;
    private final Vec<Three> yAxis;

    public static PlaneCoordinateSystem create(Plane plane, Vec<Three> center, Vec<Three> xAxis, Vec<Three> yAxis) {
        Vec<Three> yNorm;
        Objects.requireNonNull(plane, "Plane must be not null");
        Objects.requireNonNull(center, "Center must be not null");
        Objects.requireNonNull(xAxis, "X-axis must be not null");
        Objects.requireNonNull(yAxis, "Y-axis must be not null");
        if (!Vec.isInObjectSpace(center)) {
            throw new IllegalArgumentException("Center must lie inside the object space");
        }
        if (Vec.isZeroVec(xAxis)) {
            throw new IllegalArgumentException("X-Axis must be not a zero vector");
        }
        if (Vec.isZeroVec(yAxis)) {
            throw new IllegalArgumentException("Y-Axis must be not a zero vector");
        }
        Vec<Three> xOnPlane = VecHelper.subtract(xAxis, VecHelper.calculateVectorComponent(xAxis, plane.getNormal()));
        if (Vec.isZeroVec(xOnPlane)) {
            throw new IllegalArgumentException("X-Axis must be not perpendicular to the plane");
        }
        Vec<Three> yOnPlane = VecHelper.subtract(yAxis, VecHelper.calculateVectorComponent(yAxis, plane.getNormal()));
        if (Vec.isZeroVec(yOnPlane)) {
            throw new IllegalArgumentException("Y-Axis must be not perpendicular to the plane");
        }
        Vec<Three> xNorm = VecHelper.normalize(xOnPlane);
        Vec<Three> cross = VecHelper.cross(xNorm, yNorm = VecHelper.normalize(yOnPlane));
        if (Vec.isZeroVec(cross)) {
            throw new IllegalArgumentException("Both axes must be not parallel");
        }
        Vec<Three> perpendicularYNorm = VecHelper.cross(VecHelper.normalize(cross), xNorm);
        Vec<Three> centerOnPlane = VecHelper.subtract(center, VecHelper.calculateVectorComponent(VecHelper.subtract(center, plane.getInitialPoint()), plane.getNormal()));
        return new PlaneCoordinateSystem(plane, centerOnPlane, xNorm, perpendicularYNorm);
    }

    private PlaneCoordinateSystem(Plane plane, Vec<Three> center, Vec<Three> xAxis, Vec<Three> yAxis) {
        this.plane = plane;
        this.center = center;
        this.xAxis = xAxis;
        this.yAxis = yAxis;
    }

    public Vec<Two> getLocalPoint(Vec<Three> globalPoint) {
        Objects.requireNonNull(globalPoint, "Global point can't be null");
        if (!Vec.isInObjectSpace(globalPoint)) {
            throw new IllegalArgumentException("Global point must lie inside the object space");
        }
        Vec<Three> vec = VecHelper.subtract(globalPoint, this.center);
        Vec<Three> projected = VecHelper.subtract(vec, VecHelper.calculateVectorComponent(vec, this.plane.getNormal()));
        double x = VecHelper.dot(projected, this.xAxis);
        double y = VecHelper.dot(projected, this.yAxis);
        return Vec.two(x, y);
    }

    public Vec<Two> getLocalDirection(Vec<Three> globalDirection) {
        Objects.requireNonNull(globalDirection, "Global direction can't be null");
        Vec<Three> projected = VecHelper.subtract(globalDirection, VecHelper.calculateVectorComponent(globalDirection, this.plane.getNormal()));
        double x = VecHelper.dot(projected, this.xAxis);
        double y = VecHelper.dot(projected, this.yAxis);
        return Vec.two(x, y);
    }

    public Vec<Three> getGlobalPoint(Vec<Two> localPoint) {
        Objects.requireNonNull(localPoint, "Point can't be null");
        if (!Vec.isInObjectSpace(localPoint)) {
            throw new IllegalArgumentException("Global point must lie inside the object space");
        }
        Vec<Three> xDirec = VecHelper.multiply(this.xAxis, localPoint.getElement(0));
        Vec<Three> yDirec = VecHelper.multiply(this.yAxis, localPoint.getElement(1));
        Vec<Three> addDirec = VecHelper.add(xDirec, yDirec);
        Vec<Three> resultPoint = VecHelper.add(this.center, addDirec);
        return resultPoint;
    }

    public Vec<Three> getGlobalDirection(Vec<Two> localDirection) {
        Objects.requireNonNull(localDirection, "Local direction can't be null");
        Vec<Three> xDirec = VecHelper.multiply(this.xAxis, localDirection.getElement(0));
        Vec<Three> yDirec = VecHelper.multiply(this.yAxis, localDirection.getElement(1));
        return VecHelper.add(xDirec, yDirec);
    }

    @Override
    public boolean resembles(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof PlaneCoordinateSystem) {
            PlaneCoordinateSystem pcs = (PlaneCoordinateSystem)o;
            return pcs.plane.resembles(this.plane) && pcs.center.resembles(this.center) && pcs.xAxis.resembles(this.xAxis) && pcs.yAxis.resembles(this.yAxis);
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof PlaneCoordinateSystem) {
            PlaneCoordinateSystem pcs = (PlaneCoordinateSystem)o;
            return pcs.plane.equals(this.plane) && pcs.center.equals(this.center) && pcs.xAxis.equals(this.xAxis) && pcs.yAxis.equals(this.yAxis);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 3 * this.plane.hashCode() + 5 * this.center.hashCode() + 7 * this.xAxis.hashCode() + 11 * this.yAxis.hashCode();
    }

    @Override
    public String toString() {
        return "plane coordinate system: {plane: " + this.plane + ", center: " + this.center + ", x-axis: " + this.xAxis + ", y-axis: " + this.yAxis + "}";
    }

    public Plane getPlane() {
        return this.plane;
    }

    public Vec<Three> getCenter() {
        return this.center;
    }

    public Vec<Three> getXAxis() {
        return this.xAxis;
    }

    public Vec<Three> getYAxis() {
        return this.yAxis;
    }
}

