/*
 * Decompiled with CFR 0.152.
 */
package org.monospark.geometrix.plane;

import java.util.Objects;
import org.monospark.geometrix.GeometrixObject;
import org.monospark.geometrix.dimensions.Three;
import org.monospark.geometrix.util.RoundingHelper;
import org.monospark.geometrix.vector.Vec;
import org.monospark.geometrix.vector.VecHelper;

public final class Plane
extends GeometrixObject {
    private final Vec<Three> initialPoint;
    private final Vec<Three> normal;

    public static Plane create(Vec<Three> initialPoint, Vec<Three> normal) {
        Objects.requireNonNull(initialPoint, "Initial point can't be null");
        Objects.requireNonNull(normal, "Normal can't be null");
        if (Vec.isZeroVec(normal)) {
            throw new IllegalArgumentException("Normal must not be a zero vector");
        }
        if (!Vec.isInObjectSpace(initialPoint)) {
            throw new IllegalArgumentException("The initial point must lie inside object space");
        }
        Vec<Three> normalized = VecHelper.normalize(normal);
        return new Plane(initialPoint, normalized);
    }

    private Plane(Vec<Three> initialPoint, Vec<Three> normal) {
        this.initialPoint = initialPoint;
        this.normal = normal;
    }

    @Override
    public boolean resembles(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof Plane) {
            boolean normalEqual;
            Plane p = (Plane)o;
            boolean bl = normalEqual = p.normal.resembles(this.normal) || p.normal.resembles(VecHelper.negate(this.normal));
            if (normalEqual) {
                Vec<Three> p1ToP2 = VecHelper.subtract(p.initialPoint, this.initialPoint);
                double p1ToP2Length = VecHelper.calculateLength(p1ToP2);
                if (p1ToP2Length == 0.0) {
                    return true;
                }
                Vec<Three> height = VecHelper.calculateVectorComponent(this.normal, p1ToP2);
                double heightLength = VecHelper.calculateLength(height);
                return RoundingHelper.areValuesAlmostEqual(heightLength, 0.0);
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof Plane) {
            Plane p = (Plane)o;
            return p.initialPoint.equals(this.initialPoint) && p.normal.equals(this.normal);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 13 * this.initialPoint.hashCode() + 31 * this.normal.hashCode();
    }

    @Override
    public String toString() {
        return "plane: {point=" + this.initialPoint.toString() + ", normal=" + this.normal.toString() + "}";
    }

    public Vec<Three> getInitialPoint() {
        return this.initialPoint;
    }

    public Vec<Three> getNormal() {
        return this.normal;
    }
}

