/*
 * Decompiled with CFR 0.152.
 */
package org.monospark.geometrix.matrix;

import java.util.Objects;
import java.util.Optional;
import org.monospark.geometrix.dimensions.Dimension;
import org.monospark.geometrix.dimensions.OneMin;
import org.monospark.geometrix.matrix.Mat;

public final class MatHelper {
    private MatHelper() {
    }

    public static <R extends OneMin, C extends OneMin> Mat<R, C> multiply(Mat<R, C> m, double s) {
        Optional<Mat<R, C>> multiply = MatHelper.multiplyOptional(m, s);
        if (multiply.isPresent()) {
            return multiply.get();
        }
        throw new IllegalArgumentException("An element of the resulting matrix is infinite");
    }

    public static <R extends OneMin, C extends OneMin> Optional<Mat<R, C>> multiplyOptional(Mat<R, C> m, double s) {
        Objects.requireNonNull(m, "Matrix can't be null");
        if (Double.isInfinite(s) || Double.isNaN(s)) {
            throw new IllegalArgumentException("Invalid value for scalar: " + s);
        }
        double[][] values = new double[((Dimension)m.getRowDimension()).getCount()][((Dimension)m.getColumnDimension()).getCount()];
        for (int row = 0; row < ((Dimension)m.getRowDimension()).getCount(); ++row) {
            for (int column = 0; column < ((Dimension)m.getColumnDimension()).getCount(); ++column) {
                double value = m.getElement(row, column) * s;
                if (Double.isInfinite(value)) {
                    return Optional.empty();
                }
                values[row][column] = value;
            }
        }
        return Optional.of(Mat.create(values));
    }

    public static <R1 extends OneMin, C1 extends OneMin, R2 extends OneMin, C2 extends OneMin> Mat<R1, C2> multiply(Mat<R1, C1> m1, Mat<R2, C2> m2) {
        Optional<Mat<R1, C2>> multiply = MatHelper.multiplyOptional(m1, m2);
        if (multiply.isPresent()) {
            return multiply.get();
        }
        throw new IllegalArgumentException("An element of the resulting matrix is infinite");
    }

    public static <R1 extends OneMin, C1 extends OneMin, R2 extends OneMin, C2 extends OneMin> Optional<Mat<R1, C2>> multiplyOptional(Mat<R1, C1> m1, Mat<R2, C2> m2) {
        Objects.requireNonNull(m1, "First matrix can't be null");
        Objects.requireNonNull(m2, "Second matrix can't be null");
        double[][] values = new double[((Dimension)m1.getRowDimension()).getCount()][((Dimension)m2.getColumnDimension()).getCount()];
        for (int row = 0; row < ((Dimension)m1.getRowDimension()).getCount(); ++row) {
            for (int column = 0; column < ((Dimension)m2.getColumnDimension()).getCount(); ++column) {
                boolean m2InBounds;
                double m2Value;
                boolean m1InBounds = row < ((Dimension)m1.getRowDimension()).getCount() && column < ((Dimension)m1.getColumnDimension()).getCount();
                double m1Value = m1InBounds ? m1.getElement(row, column) : 0.0;
                double value = m1Value * (m2Value = (m2InBounds = row < ((Dimension)m2.getRowDimension()).getCount() && column < ((Dimension)m2.getColumnDimension()).getCount()) ? m2.getElement(column, row) : 0.0);
                if (Double.isInfinite(value)) {
                    return Optional.empty();
                }
                values[row][column] = value;
            }
        }
        return Optional.of(Mat.create(values));
    }

    public static <R extends OneMin, C extends OneMin> Mat<R, C> divide(Mat<R, C> m, double s) {
        Optional<Mat<R, C>> divide = MatHelper.divideOptional(m, s);
        if (divide.isPresent()) {
            return divide.get();
        }
        throw new IllegalArgumentException("An element of the resulting matrix is infinite");
    }

    public static <R extends OneMin, C extends OneMin> Optional<Mat<R, C>> divideOptional(Mat<R, C> m, double s) {
        Objects.requireNonNull(m, "Matrix can't be null");
        if (Double.isInfinite(s) || Double.isNaN(s)) {
            throw new IllegalArgumentException("Invalid value for scalar: " + s);
        }
        double[][] values = new double[((Dimension)m.getRowDimension()).getCount()][((Dimension)m.getColumnDimension()).getCount()];
        for (int row = 0; row < ((Dimension)m.getRowDimension()).getCount(); ++row) {
            for (int column = 0; column < ((Dimension)m.getColumnDimension()).getCount(); ++column) {
                double value = m.getElement(row, column) / s;
                if (Double.isInfinite(value)) {
                    return Optional.empty();
                }
                values[row][column] = value;
            }
        }
        return Optional.of(Mat.create(values));
    }

    public static <R extends OneMin, C extends OneMin> double[] toArray(Mat<R, C> m, Mat.ElementOrder order) {
        Objects.requireNonNull(m, "Matrix can't be null");
        Objects.requireNonNull(order, "Element order can't be null");
        double[] values = new double[((Dimension)m.getRowDimension()).getCount() * ((Dimension)m.getColumnDimension()).getCount()];
        for (int row = 0; row < ((Dimension)m.getRowDimension()).getCount(); ++row) {
            for (int column = 0; column < ((Dimension)m.getColumnDimension()).getCount(); ++column) {
                values[order.getIndex((int)row, (int)column, (int)((Dimension)m.getRowDimension()).getCount(), (int)((Dimension)m.getColumnDimension()).getCount())] = m.getElement(row, column);
            }
        }
        return values;
    }
}

