/*
 * Decompiled with CFR 0.152.
 */
package org.monospark.geometrix.matrix;

import java.util.Arrays;
import java.util.Objects;
import org.monospark.geometrix.GeometrixObject;
import org.monospark.geometrix.dimensions.Dimension;
import org.monospark.geometrix.dimensions.Four;
import org.monospark.geometrix.dimensions.One;
import org.monospark.geometrix.dimensions.OneMin;
import org.monospark.geometrix.dimensions.Three;
import org.monospark.geometrix.dimensions.Two;
import org.monospark.geometrix.util.RoundingHelper;

public final class Mat<R extends OneMin, C extends OneMin>
extends GeometrixObject {
    private final R rowDim;
    private final C columnDim;
    private final double[][] elements;

    static <R extends OneMin, C extends OneMin> Mat<R, C> create(double[][] values) {
        return new Mat<OneMin, OneMin>((OneMin)Dimension.getDimension(values.length), (OneMin)Dimension.getDimension(values[0].length), values);
    }

    public static <R extends OneMin, C extends OneMin> Mat<R, C> zero(R rowDim, C columnDim) {
        return Mat.create(rowDim, columnDim, ElementOrder.ROW_MAJOR, new double[rowDim.getCount() * columnDim.getCount()]);
    }

    public static Mat<One, One> oneByOne(ElementOrder order, double element) {
        return Mat.create(Dimension.ONE, Dimension.ONE, order, element);
    }

    public static Mat<Two, Two> twoByTwo(ElementOrder order, double ... elements) {
        return Mat.create(Dimension.TWO, Dimension.TWO, order, elements);
    }

    public static Mat<Three, Three> threeByThree(ElementOrder order, double ... elements) {
        return Mat.create(Dimension.THREE, Dimension.THREE, order, elements);
    }

    public static Mat<Four, Four> fourByFour(ElementOrder order, double ... elements) {
        return Mat.create(Dimension.FOUR, Dimension.FOUR, order, elements);
    }

    public static <D extends OneMin> Mat<D, D> identity(D dim) {
        Objects.requireNonNull(dim, "Dimension must be not null");
        double[] elements = new double[dim.getCount() * dim.getCount()];
        for (int i = 0; i < dim.getCount(); ++i) {
            elements[ElementOrder.ROW_MAJOR.getIndex((int)i, (int)i, (int)dim.getCount(), (int)dim.getCount())] = 1.0;
        }
        return Mat.create(dim, dim, ElementOrder.ROW_MAJOR, elements);
    }

    public static <R extends OneMin, C extends OneMin> Mat<R, C> create(R rowDim, C columnDim, ElementOrder order, double ... elements) {
        Objects.requireNonNull(rowDim, "Row-dimension can't be null");
        Objects.requireNonNull(columnDim, "Column-dimension can't be null");
        Objects.requireNonNull(order, "The element order must be not null");
        Objects.requireNonNull(elements, "Element array can't be null");
        if (rowDim.getCount() * columnDim.getCount() != elements.length) {
            throw new IllegalArgumentException("The row-dimension and column-dimensiondon't match the size of the element array");
        }
        double[][] newValues = new double[columnDim.getCount()][rowDim.getCount()];
        for (int row = 0; row < rowDim.getCount(); ++row) {
            for (int column = 0; column < columnDim.getCount(); ++column) {
                newValues[column][row] = elements[order.getIndex(row, column, rowDim.getCount(), columnDim.getCount())];
            }
        }
        return new Mat<R, C>(rowDim, columnDim, newValues);
    }

    private Mat(R rowDim, C columnDim, double[][] elements) {
        for (int row = 0; row < ((Dimension)rowDim).getCount(); ++row) {
            for (int column = 0; column < ((Dimension)columnDim).getCount(); ++column) {
                double value = elements[column][row];
                if (!Double.isInfinite(value) && !Double.isNaN(value)) continue;
                throw new IllegalArgumentException("The matrix element at [" + row + "][" + column + "] is invalid.");
            }
        }
        this.rowDim = rowDim;
        this.columnDim = columnDim;
        this.elements = elements;
    }

    public double getElement(int row, int column) {
        if (row >= ((Dimension)this.rowDim).getCount() || row < 0) {
            throw new IndexOutOfBoundsException("Row parameter is out of bounds. Allowed: 0-" + (((Dimension)this.rowDim).getCount() - 1) + ", but was " + row);
        }
        if (column >= ((Dimension)this.columnDim).getCount() || column < 0) {
            throw new IndexOutOfBoundsException("Column parameter is out of bounds. Allowed: 0-" + (((Dimension)this.columnDim).getCount() - 1) + ", but was " + column);
        }
        double matValue = this.elements[column][row];
        return matValue;
    }

    @Override
    public boolean resembles(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (this.getClass().isInstance(o)) {
            Mat mat = (Mat)o;
            if (!mat.rowDim.equals(this.rowDim) || !mat.columnDim.equals(this.columnDim)) {
                return false;
            }
            for (int row = 0; row < ((Dimension)this.rowDim).getCount(); ++row) {
                for (int column = 0; column < ((Dimension)this.columnDim).getCount(); ++column) {
                    double m2Value;
                    double m1Value = this.getElement(row, column);
                    if (RoundingHelper.areValuesAlmostEqual(m1Value, m2Value = mat.getElement(row, column))) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (this.getClass().isInstance(o)) {
            Mat mat = (Mat)o;
            return this.rowDim.equals(mat.rowDim) && this.columnDim.equals(mat.columnDim) && Arrays.deepEquals((Object[])this.elements, (Object[])mat.elements);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Arrays.deepHashCode((Object[])this.elements);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        for (int row = 0; row < ((Dimension)this.rowDim).getCount(); ++row) {
            b.append('[');
            for (int column = 0; column < ((Dimension)this.columnDim).getCount(); ++column) {
                double value = this.elements[row][column];
                b.append(value);
                b.append(',');
            }
            b.deleteCharAt(b.length() - 1);
            b.append(']');
        }
        b.deleteCharAt(b.length() - 1);
        return b.toString();
    }

    public R getRowDimension() {
        return this.rowDim;
    }

    public C getColumnDimension() {
        return this.columnDim;
    }

    public static abstract class ElementOrder {
        public static final ElementOrder ROW_MAJOR = new ElementOrder(){

            @Override
            protected int getIndex(int row, int column, int rowSize, int columnSize) {
                return column * rowSize + row;
            }
        };
        public static final ElementOrder COLUMN_MAJOR = new ElementOrder(){

            @Override
            protected int getIndex(int row, int column, int rowSize, int columnSize) {
                return row * columnSize + column;
            }
        };

        private ElementOrder() {
        }

        protected abstract int getIndex(int var1, int var2, int var3, int var4);
    }
}

