/*
 * Decompiled with CFR 0.152.
 */
package org.monospark.geometrix.lineseg;

import java.util.Objects;
import java.util.Optional;
import org.monospark.geometrix.dimensions.TwoMin;
import org.monospark.geometrix.line.Line;
import org.monospark.geometrix.line.LineHelper;
import org.monospark.geometrix.lineseg.LineSeg;
import org.monospark.geometrix.util.RoundingHelper;
import org.monospark.geometrix.vector.Vec;
import org.monospark.geometrix.vector.VecHelper;

public final class LineSegHelper {
    private LineSegHelper() {
    }

    public static <D extends TwoMin> double calculateLength(LineSeg<D> ls) {
        Objects.requireNonNull(ls, "Line segment can't be null");
        return VecHelper.calculateLength(VecHelper.subtract(ls.getP2(), ls.getP1()));
    }

    public static <D extends TwoMin> Line<D> calculateLine(LineSeg<D> ls) {
        Objects.requireNonNull(ls, "Line segment can't be null");
        return Line.create(ls.getP1(), VecHelper.subtract(ls.getP2(), ls.getP1()));
    }

    public static <D extends TwoMin> boolean isPointOnLineSegment(LineSeg<D> ls, Vec<D> p) {
        Objects.requireNonNull(ls, "Line segment can't be null");
        Objects.requireNonNull(p, "Point can't be null");
        if (ls.getP1().resembles(p) || ls.getP2().resembles(p)) {
            return true;
        }
        Vec<D> segDirection = VecHelper.subtract(ls.getP2(), ls.getP1());
        double segLength = LineSegHelper.calculateLength(ls);
        Vec<D> toPoint = VecHelper.subtract(p, ls.getP1());
        Vec<D> sidewaysToPoint = VecHelper.subtract(toPoint, VecHelper.calculateVectorComponent(toPoint, segDirection));
        double sideways = VecHelper.calculateLength(sidewaysToPoint);
        if (!RoundingHelper.areValuesAlmostEqual(sideways, 0.0)) {
            return false;
        }
        Vec<D> p1ToPoint = toPoint;
        if (VecHelper.calculateLength(p1ToPoint) > segLength) {
            return false;
        }
        Vec<D> p2ToPoint = VecHelper.subtract(p, ls.getP2());
        return !(VecHelper.calculateLength(p2ToPoint) > segLength);
    }

    public static <D extends TwoMin> Optional<Vec<D>> calculateIntersectionPoint(LineSeg<D> ls1, LineSeg<D> ls2) {
        Objects.requireNonNull(ls1, "First line segment can't be null");
        Objects.requireNonNull(ls2, "Second line segment can't be null");
        Line<D> l1 = LineSegHelper.calculateLine(ls1);
        Line<D> l2 = LineSegHelper.calculateLine(ls2);
        Optional<Vec<D>> inter = LineHelper.calculateIntersectionPoint(l1, l2);
        if (!inter.isPresent()) {
            return Optional.empty();
        }
        boolean onBothLines = LineSegHelper.isPointOnLineSegment(ls1, inter.get()) && LineSegHelper.isPointOnLineSegment(ls2, inter.get());
        return onBothLines ? inter : Optional.empty();
    }
}

