/*
 * Decompiled with CFR 0.152.
 */
package org.monospark.geometrix.lineseg;

import java.util.Objects;
import org.monospark.geometrix.GeometrixObject;
import org.monospark.geometrix.dimensions.TwoMin;
import org.monospark.geometrix.vector.Vec;

public final class LineSeg<D extends TwoMin>
extends GeometrixObject {
    private final Vec<D> p1;
    private final Vec<D> p2;

    public static <D extends TwoMin> LineSeg<D> create(Vec<D> p1, Vec<D> p2) {
        Objects.requireNonNull(p1, "The first point can't be null");
        Objects.requireNonNull(p2, "The second point can't be null");
        if (p1.equals(p2)) {
            throw new IllegalArgumentException("The points must be unequal to each other");
        }
        if (!Vec.isInObjectSpace(p1)) {
            throw new IllegalArgumentException("The first point does not lie inside object space");
        }
        if (!Vec.isInObjectSpace(p2)) {
            throw new IllegalArgumentException("The second point does not lie inside object space");
        }
        return new LineSeg<D>(p1, p2);
    }

    private LineSeg(Vec<D> p1, Vec<D> p2) {
        this.p1 = p1;
        this.p2 = p2;
    }

    @Override
    public boolean resembles(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (this.getClass().isInstance(o)) {
            LineSeg s = (LineSeg)o;
            return s.p1.resembles(this.p1) && s.p2.resembles(this.p2) || s.p1.resembles(this.p2) && s.p2.resembles(this.p1);
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (this.getClass().isInstance(o)) {
            LineSeg s = (LineSeg)o;
            return s.p1.equals(this.p1) && s.p2.equals(this.p2);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 13 * this.p1.hashCode() + 31 * this.p2.hashCode();
    }

    @Override
    public String toString() {
        return "line segment: {p1=" + this.p1 + ", p2=" + this.p2 + "}";
    }

    public D getDimension() {
        return (D)((TwoMin)this.p1.getDimension());
    }

    public Vec<D> getP1() {
        return this.p1;
    }

    public Vec<D> getP2() {
        return this.p2;
    }
}

