/*
 * Decompiled with CFR 0.152.
 */
package org.monospark.geometrix.line;

import java.util.Objects;
import java.util.Optional;
import org.monospark.geometrix.dimensions.Dimension;
import org.monospark.geometrix.dimensions.Two;
import org.monospark.geometrix.dimensions.TwoMin;
import org.monospark.geometrix.line.Line;
import org.monospark.geometrix.plane.Plane;
import org.monospark.geometrix.plane.PlaneCoordinateSystem;
import org.monospark.geometrix.plane.PlaneHelper;
import org.monospark.geometrix.util.RoundingHelper;
import org.monospark.geometrix.vector.Vec;
import org.monospark.geometrix.vector.VecHelper;

public final class LineHelper {
    private LineHelper() {
    }

    public static <D extends TwoMin> boolean isPointOnLine(Line<D> l, Vec<D> p) {
        Objects.requireNonNull(l, "Line can't be null");
        Objects.requireNonNull(p, "Point can't be null");
        Vec<D> toPoint = VecHelper.subtract(p, l.getInitialPoint());
        double toPointLength = VecHelper.calculateLength(toPoint);
        if (RoundingHelper.areValuesAlmostEqual(toPointLength, 0.0)) {
            return true;
        }
        Vec<D> sidewaysToPoint = VecHelper.subtract(toPoint, VecHelper.calculateVectorComponent(toPoint, l.getDirection()));
        double sideways = VecHelper.calculateLength(sidewaysToPoint);
        return RoundingHelper.areValuesAlmostEqual(sideways, 0.0);
    }

    public static <D extends TwoMin> boolean areLinesParallel(Line<D> l1, Line<D> l2) {
        Objects.requireNonNull(l1, "First line can't be null");
        Objects.requireNonNull(l2, "Second line can't be null");
        return l1.getDirection().resembles(l2.getDirection()) || l1.getDirection().resembles(VecHelper.negate(l2.getDirection()));
    }

    public static <D extends TwoMin> Optional<Vec<D>> calculateIntersectionPoint(Line<D> l1, Line<D> l2) {
        Line<Two> l2Two;
        Objects.requireNonNull(l1, "First line can't be null");
        Objects.requireNonNull(l2, "Second line can't be null");
        if (LineHelper.areLinesParallel(l1, l2)) {
            return Optional.empty();
        }
        if (LineHelper.isPointOnLine(l1, l2.getInitialPoint())) {
            return Optional.of(l2.getInitialPoint());
        }
        if (LineHelper.isPointOnLine(l2, l1.getInitialPoint())) {
            return Optional.of(l1.getInitialPoint());
        }
        if (l1.getDimension().equals(Dimension.TWO)) {
            Vec<Two> inter = LineHelper.calculateIntersectionPoint2D(l1, l2);
            if (inter == null) {
                return Optional.empty();
            }
            return Optional.of(inter);
        }
        Line<Two> l1Three = l1;
        Line<Two> l2Three = l2;
        Plane plane = Plane.create(l1Three.getInitialPoint(), VecHelper.cross(l1Three.getDirection(), l2Three.getDirection()));
        if (!PlaneHelper.isPointOnPlane(plane, l2Three.getInitialPoint())) {
            return Optional.empty();
        }
        Vec<Two> middle = VecHelper.divide(VecHelper.add(l1Three.getInitialPoint(), l2Three.getInitialPoint()), 2.0);
        PlaneCoordinateSystem coordSystem = PlaneCoordinateSystem.create(plane, middle, l1Three.getDirection(), l2Three.getDirection());
        Line<Two> l1Two = Line.create(coordSystem.getLocalPoint(l1Three.getInitialPoint()), coordSystem.getLocalDirection(l1Three.getDirection()));
        Vec<Two> inter = LineHelper.calculateIntersectionPoint2D(l1Two, l2Two = Line.create(coordSystem.getLocalPoint(l2Three.getInitialPoint()), coordSystem.getLocalDirection(l2Three.getDirection())));
        if (inter == null || !Vec.isInObjectSpace(inter)) {
            return Optional.empty();
        }
        return Optional.of(coordSystem.getGlobalPoint(inter));
    }

    private static Vec<Two> calculateIntersectionPoint2D(Line<Two> l1, Line<Two> l2) {
        double yCoord;
        double xCoord;
        Vec<Two> p11 = l1.getInitialPoint();
        Vec<Two> p12 = VecHelper.add(l1.getInitialPoint(), l1.getDirection());
        Vec<Two> p21 = l2.getInitialPoint();
        Vec<Two> p22 = VecHelper.add(l2.getInitialPoint(), l2.getDirection());
        double detDenominator = (p11.getElement(0) - p12.getElement(0)) * (p21.getElement(1) - p22.getElement(1)) - (p11.getElement(1) - p12.getElement(1)) * (p21.getElement(0) - p22.getElement(0));
        double xNominator = (p11.getElement(0) * p12.getElement(1) - p11.getElement(1) * p12.getElement(0)) * (p21.getElement(0) - p22.getElement(0)) - (p11.getElement(0) - p12.getElement(0)) * (p21.getElement(0) * p22.getElement(1) - p21.getElement(1) * p22.getElement(0));
        double d = xCoord = xNominator == 0.0 ? 0.0 : xNominator / detDenominator;
        if (Double.isInfinite(xCoord)) {
            return null;
        }
        double yNominator = (p11.getElement(0) * p12.getElement(1) - p11.getElement(1) * p12.getElement(0)) * (p21.getElement(1) - p22.getElement(1)) - (p11.getElement(1) - p12.getElement(1)) * (p21.getElement(0) * p22.getElement(1) - p21.getElement(1) * p22.getElement(0));
        double d2 = yCoord = yNominator == 0.0 ? 0.0 : yNominator / detDenominator;
        if (Double.isInfinite(yCoord)) {
            return null;
        }
        Optional<Vec<Two>> inter = Vec.createOptional(Dimension.TWO, xCoord, yCoord);
        return inter.isPresent() ? inter.get() : null;
    }
}

