/*
 * Decompiled with CFR 0.152.
 */
package org.monospark.geometrix.line;

import java.util.Objects;
import org.monospark.geometrix.GeometrixObject;
import org.monospark.geometrix.dimensions.TwoMin;
import org.monospark.geometrix.line.LineHelper;
import org.monospark.geometrix.vector.Vec;
import org.monospark.geometrix.vector.VecHelper;

public final class Line<D extends TwoMin>
extends GeometrixObject {
    private final Vec<D> initialPoint;
    private final Vec<D> direction;

    public static <D extends TwoMin> Line<D> create(Vec<D> initialPoint, Vec<D> direc) {
        Objects.requireNonNull(initialPoint, "Initial point can't be null");
        Objects.requireNonNull(direc, "Direction can't be null");
        if (Vec.isZeroVec(direc)) {
            throw new IllegalArgumentException("The direction vector must not be zero vector");
        }
        if (!Vec.isInObjectSpace(initialPoint)) {
            throw new IllegalArgumentException("The initial point must lie inside object space");
        }
        Vec<D> normalizedDirec = VecHelper.normalize(direc);
        return new Line<D>(initialPoint, normalizedDirec);
    }

    private Line(Vec<D> initPoint, Vec<D> direc) {
        this.initialPoint = initPoint;
        this.direction = direc;
    }

    @Override
    public boolean resembles(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (this.getClass().isInstance(o)) {
            Line l = (Line)o;
            if (!l.getDimension().equals(this.getDimension())) {
                return false;
            }
            Line castLine = l;
            return LineHelper.areLinesParallel(castLine, this) && LineHelper.isPointOnLine(castLine, this.initialPoint);
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (this.getClass().isInstance(o)) {
            Line s = (Line)o;
            return s.initialPoint.equals(this.initialPoint) && s.direction.equals(this.direction);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 13 * this.initialPoint.hashCode() + 31 * this.direction.hashCode();
    }

    @Override
    public String toString() {
        return "line: {p=" + this.initialPoint + ", direc=" + this.direction + "}";
    }

    public D getDimension() {
        return (D)((TwoMin)this.initialPoint.getDimension());
    }

    public Vec<D> getInitialPoint() {
        return this.initialPoint;
    }

    public Vec<D> getDirection() {
        return this.direction;
    }
}

