/*
 * Decompiled with CFR 0.152.
 */
package org.monospark.geometrix.dimensions;

import java.util.HashSet;
import java.util.Set;
import org.monospark.geometrix.dimensions.DimensionDuplicateException;
import org.monospark.geometrix.dimensions.Four;
import org.monospark.geometrix.dimensions.One;
import org.monospark.geometrix.dimensions.Three;
import org.monospark.geometrix.dimensions.Two;

public abstract class Dimension {
    private static final Set<Dimension> dimensions = new HashSet<Dimension>();
    public static final One ONE = new One();
    public static final Two TWO = new Two();
    public static final Three THREE = new Three();
    public static final Four FOUR = new Four();
    private final int count;

    private static void addDimension(Dimension d) {
        Dimension existent = Dimension.getDimension(d.count);
        if (existent != null) {
            throw new DimensionDuplicateException("A dimension with the coordinate amount of " + d.count + " already exists");
        }
        dimensions.add(d);
    }

    public static Dimension getDimension(int count) {
        for (Dimension dim : dimensions) {
            if (dim.count != count) continue;
            return dim;
        }
        return null;
    }

    Dimension(int count) {
        Dimension.addDimension(this);
        this.count = count;
    }

    public int getCount() {
        return this.count;
    }
}

