/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.search;

import com.mongodb.annotations.Beta;
import com.mongodb.annotations.Reason;
import com.mongodb.annotations.Sealed;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.search.FieldSearchPath;
import com.mongodb.client.model.search.SearchConstructibleBson;
import com.mongodb.client.model.search.WildcardSearchPath;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.conversions.Bson;

@Sealed
@Beta(value={Reason.CLIENT})
public interface SearchPath
extends Bson {
    public static FieldSearchPath fieldPath(String path) {
        Assertions.notNull("path", path);
        Assertions.isTrueArgument("path must not contain '*'", !path.contains("*"));
        return new SearchConstructibleBson((Bson)new BsonDocument("value", (BsonValue)new BsonString(path)));
    }

    public static WildcardSearchPath wildcardPath(String wildcardPath) {
        Assertions.notNull("wildcardPath", wildcardPath);
        Assertions.isTrueArgument("wildcardPath must contain '*'", wildcardPath.contains("*"));
        Assertions.isTrueArgument("wildcardPath must not contain '**'", !wildcardPath.contains("**"));
        return new SearchConstructibleBson((Bson)new BsonDocument("wildcard", (BsonValue)new BsonString(wildcardPath)));
    }

    default public BsonValue toBsonValue() {
        BsonDocument doc = this.toBsonDocument();
        if (doc.size() > 1) {
            return doc;
        }
        BsonString value = doc.getString((Object)"value", null);
        if (value != null) {
            return value;
        }
        return doc;
    }
}

