/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.postgresql.identifier;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.postgresql.PostgreSqlNameGenerator;
import org.molgenis.data.postgresql.identifier.AttributeDescription;
import org.molgenis.data.postgresql.identifier.EntityTypeDescription;
import org.molgenis.data.postgresql.identifier.EntityTypeRegistry;
import org.molgenis.data.transaction.TransactionListener;
import org.molgenis.data.transaction.TransactionManager;
import org.molgenis.data.util.EntityTypeUtils;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Component
public class EntityTypeRegistryImpl
implements EntityTypeRegistry,
TransactionListener {
    private final ConcurrentMap<String, EntityTypeDescription> entityTypeDescriptionMap = new ConcurrentHashMap<String, EntityTypeDescription>();
    private final ConcurrentMap<String, Map<String, EntityTypeDescription>> transactionsEntityTypeDescriptionMap = new ConcurrentHashMap<String, Map<String, EntityTypeDescription>>();

    EntityTypeRegistryImpl(TransactionManager transactionManager) {
        transactionManager.addTransactionListener((TransactionListener)this);
    }

    @Override
    public void registerEntityType(EntityType entityType) {
        Iterable attributes = entityType.getAtomicAttributes();
        EntityTypeDescription entityTypeDescription = this.createEntityTypeDescription(entityType, attributes);
        this.registerTableNames(this.getTableNames(entityType, Streams.stream((Iterable)attributes)), entityTypeDescription);
    }

    @Override
    public void unregisterEntityType(EntityType entityType) {
        Iterable attributes = entityType.getAtomicAttributes();
        this.registerTableNames(this.getTableNames(entityType, Streams.stream((Iterable)attributes)), null);
    }

    @Override
    public void addAttribute(EntityType entityType, Attribute attribute) {
        Iterable attributes = Iterables.concat((Iterable)entityType.getAtomicAttributes(), (Iterable)ImmutableList.of((Object)attribute));
        EntityTypeDescription entityTypeDescription = this.createEntityTypeDescription(entityType, attributes);
        this.registerTableNames(this.getTableNames(entityType, Streams.stream((Iterable)attributes)), entityTypeDescription);
    }

    @Override
    public void updateAttribute(EntityType entityType, Attribute attr, Attribute updatedAttr) {
        this.registerTableNames(this.getJunctionTableNames(entityType, Stream.of(attr)), null);
        List<Attribute> attributes = Streams.stream((Iterable)entityType.getAtomicAttributes()).filter(existing -> !existing.getName().equals(attr.getName())).collect(Collectors.toList());
        attributes.add(updatedAttr);
        EntityTypeDescription entityTypeDescription = this.createEntityTypeDescription(entityType, attributes);
        this.registerTableNames(this.getTableNames(entityType, attributes.stream()), entityTypeDescription);
    }

    @Override
    public void deleteAttribute(EntityType entityType, Attribute attr) {
        this.registerTableNames(this.getJunctionTableNames(entityType, Stream.of(attr)), null);
        List<Attribute> attributes = Streams.stream((Iterable)entityType.getAtomicAttributes()).filter(existing -> !existing.getName().equals(attr.getName())).collect(Collectors.toList());
        EntityTypeDescription entityTypeDescription = this.createEntityTypeDescription(entityType, attributes);
        this.registerTableNames(this.getTableNames(entityType, attributes.stream()), entityTypeDescription);
    }

    private Set<String> getTableNames(EntityType entityType, Stream<Attribute> attributes) {
        HashSet tableNames = Sets.newHashSet((Object[])new String[]{this.getTableName(entityType)});
        tableNames.addAll(this.getJunctionTableNames(entityType, attributes));
        return tableNames;
    }

    private Set<String> getJunctionTableNames(EntityType entityType, Stream<Attribute> attributes) {
        return attributes.filter(EntityTypeRegistryImpl::hasJunctionTable).map(attribute -> PostgreSqlNameGenerator.getJunctionTableName(entityType, attribute, false)).collect(Collectors.toSet());
    }

    private EntityTypeDescription createEntityTypeDescription(EntityType entityType, Iterable<Attribute> attributes) {
        Map<String, AttributeDescription> attributeDescriptions = Streams.stream(attributes).filter(attribute -> !EntityTypeRegistryImpl.hasJunctionTable(attribute)).collect(Collectors.toMap(this::getColumnName, attribute -> AttributeDescription.create(attribute.getName())));
        return EntityTypeDescription.create(entityType.getId(), attributeDescriptions);
    }

    private void registerTableNames(Set<String> tableNames, EntityTypeDescription entityTypeDescription) {
        tableNames.forEach(tableName -> this.registerTableName(entityTypeDescription, (String)tableName));
    }

    private void registerTableName(EntityTypeDescription entityTypeDescription, String tableName) {
        if (entityTypeDescription == null && this.getTransactionId() == null) {
            this.entityTypeDescriptionMap.remove(tableName);
        } else {
            this.getEntityTypeDescriptionMap().put(tableName, entityTypeDescription);
        }
    }

    private static boolean hasJunctionTable(Attribute attribute) {
        return EntityTypeUtils.isMultipleReferenceType((Attribute)attribute) && attribute.getDataType() != AttributeType.ONE_TO_MANY;
    }

    @Override
    public EntityTypeDescription getEntityTypeDescription(String tableName) {
        return (EntityTypeDescription)((Map)Optional.ofNullable(this.getTransactionId()).filter(this.transactionsEntityTypeDescriptionMap::containsKey).map(this.transactionsEntityTypeDescriptionMap::get).filter(transactionMap -> transactionMap.containsKey(tableName)).orElse(this.entityTypeDescriptionMap)).get(tableName);
    }

    public void afterCommitTransaction(String transactionId) {
        Map transactionEntityTypeDescriptionMap = (Map)this.transactionsEntityTypeDescriptionMap.remove(transactionId);
        if (transactionEntityTypeDescriptionMap != null) {
            transactionEntityTypeDescriptionMap.forEach((tableName, entityTypeDescription) -> {
                if (entityTypeDescription != null) {
                    this.entityTypeDescriptionMap.put((String)tableName, (EntityTypeDescription)entityTypeDescription);
                } else {
                    this.entityTypeDescriptionMap.remove(tableName);
                }
            });
        }
    }

    public void rollbackTransaction(String transactionId) {
        this.transactionsEntityTypeDescriptionMap.remove(transactionId);
    }

    private String getTransactionId() {
        return (String)TransactionSynchronizationManager.getResource((Object)"transactionId");
    }

    private String getTableName(EntityType entityType) {
        return PostgreSqlNameGenerator.getTableName(entityType, false);
    }

    private String getColumnName(Attribute attr) {
        return PostgreSqlNameGenerator.getColumnName(attr, false);
    }

    private Map<String, EntityTypeDescription> getEntityTypeDescriptionMap() {
        String transactionId = this.getTransactionId();
        if (transactionId == null) {
            return this.entityTypeDescriptionMap;
        }
        return this.transactionsEntityTypeDescriptionMap.computeIfAbsent(transactionId, k -> new HashMap());
    }
}

