/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.postgresql;

import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.postgresql.identifier.AttributeDescription;
import org.molgenis.data.postgresql.identifier.EntityTypeDescription;
import org.molgenis.data.postgresql.identifier.EntityTypeRegistry;
import org.molgenis.data.transaction.TransactionExceptionTranslator;
import org.molgenis.data.validation.MolgenisValidationException;
import org.molgenis.validation.ConstraintViolation;
import org.postgresql.util.PSQLException;
import org.postgresql.util.ServerErrorMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionException;

@Component
class PostgreSqlExceptionTranslator
extends SQLErrorCodeSQLExceptionTranslator
implements TransactionExceptionTranslator {
    static final String VALUE_TOO_LONG_MSG = "One of the values being added is too long.";
    private static final Logger LOG = LoggerFactory.getLogger(PostgreSqlExceptionTranslator.class);
    private static final String ERROR_TRANSLATING_POSTGRES_EXC_MSG = "Error translating postgres exception: ";
    private static final String ERROR_TRANSLATING_EXCEPTION_MSG = "Error translating exception";
    private final EntityTypeRegistry entityTypeRegistry;
    private static final String TOKEN_UNKNOWN = "<unknown>";

    PostgreSqlExceptionTranslator(DataSource dataSource, EntityTypeRegistry entityTypeRegistry) {
        super(Objects.requireNonNull(dataSource));
        this.entityTypeRegistry = Objects.requireNonNull(entityTypeRegistry);
    }

    protected DataAccessException doTranslate(String task, String sql, SQLException ex) {
        DataAccessException dataAccessException = super.doTranslate(task, sql, ex);
        if (dataAccessException == null) {
            return this.doTranslate(ex);
        }
        return this.doTranslate(dataAccessException);
    }

    private MolgenisDataException doTranslate(DataAccessException dataAccessException) {
        Throwable cause = dataAccessException.getCause();
        if (!(cause instanceof PSQLException)) {
            throw new RuntimeException(String.format("Unexpected exception class [%s]", cause.getClass().getSimpleName()));
        }
        PSQLException pSqlException = (PSQLException)cause;
        MolgenisDataException molgenisDataException = this.doTranslate(pSqlException);
        if (molgenisDataException == null) {
            molgenisDataException = new MolgenisDataException((Throwable)dataAccessException);
        }
        return molgenisDataException;
    }

    private MolgenisDataException doTranslate(SQLException sqlException) {
        if (sqlException instanceof BatchUpdateException) {
            sqlException = sqlException.getNextException();
        }
        if (!(sqlException instanceof PSQLException)) {
            LOG.error("", (Throwable)sqlException);
            throw new RuntimeException(String.format("Unexpected exception class [%s]", sqlException.getClass().getSimpleName()));
        }
        PSQLException pSqlException = (PSQLException)sqlException;
        MolgenisDataException molgenisDataException = this.doTranslate(pSqlException);
        if (molgenisDataException == null) {
            molgenisDataException = new MolgenisDataException((Throwable)sqlException);
        }
        return molgenisDataException;
    }

    private MolgenisDataException doTranslate(PSQLException pSqlException) {
        switch (pSqlException.getSQLState()) {
            case "22001": {
                return this.translateValueTooLongViolation();
            }
            case "22007": 
            case "22P02": {
                return PostgreSqlExceptionTranslator.translateInvalidIntegerException(pSqlException);
            }
            case "23502": {
                return this.translateNotNullViolation(pSqlException);
            }
            case "23503": {
                return this.translateForeignKeyViolation(pSqlException);
            }
            case "23505": {
                return this.translateUniqueKeyViolation(pSqlException);
            }
            case "23514": {
                return this.translateCheckConstraintViolation(pSqlException);
            }
            case "2BP01": {
                return this.translateDependentObjectsStillExist(pSqlException);
            }
            case "42703": {
                return PostgreSqlExceptionTranslator.translateUndefinedColumnException(pSqlException);
            }
            case "23506": {
                return this.translateReadonlyViolation(pSqlException);
            }
        }
        return null;
    }

    MolgenisValidationException translateValueTooLongViolation() {
        ConstraintViolation constraintViolation = new ConstraintViolation(VALUE_TOO_LONG_MSG);
        return new MolgenisValidationException(Collections.singleton(constraintViolation));
    }

    MolgenisValidationException translateReadonlyViolation(PSQLException pSqlException) {
        Matcher matcher = Pattern.compile("Updating read-only column \"?(.*?)\"? of table \"?(.*?)\"? with id \\[(.*?)] is not allowed").matcher(pSqlException.getServerErrorMessage().getMessage());
        boolean matches = matcher.matches();
        if (!matches) {
            LOG.error(ERROR_TRANSLATING_POSTGRES_EXC_MSG, (Throwable)pSqlException);
            throw new RuntimeException(ERROR_TRANSLATING_EXCEPTION_MSG, (Throwable)pSqlException);
        }
        String colName = matcher.group(1);
        String tableName = matcher.group(2);
        String id = matcher.group(3);
        ConstraintViolation constraintViolation = new ConstraintViolation(String.format("Updating read-only attribute '%s' of entity '%s' with id '%s' is not allowed.", this.tryGetAttributeName(tableName, colName).orElse(TOKEN_UNKNOWN), this.tryGetEntityTypeName(tableName).orElse(TOKEN_UNKNOWN), id));
        return new MolgenisValidationException(Collections.singleton(constraintViolation));
    }

    MolgenisValidationException translateDependentObjectsStillExist(PSQLException pSqlException) {
        ServerErrorMessage serverErrorMessage = pSqlException.getServerErrorMessage();
        String detail = serverErrorMessage.getDetail();
        Matcher matcher = Pattern.compile("constraint (.+) on table \"?([^\"]+)\"? depends on table \"?([^\"]+)\"?\n?").matcher(detail);
        LinkedHashMap<String, Set> entityTypeDependencyMap = new LinkedHashMap<String, Set>();
        while (matcher.find()) {
            String tableName = matcher.group(2);
            String dependentTableName = matcher.group(3);
            String entityTypeName = this.tryGetEntityTypeName(tableName).orElse(TOKEN_UNKNOWN);
            String dependentEntityTypeName = this.tryGetEntityTypeName(dependentTableName).orElse(TOKEN_UNKNOWN);
            Set dependentTableNames = entityTypeDependencyMap.computeIfAbsent(dependentEntityTypeName, k -> new LinkedHashSet());
            dependentTableNames.add(entityTypeName);
        }
        if (entityTypeDependencyMap.isEmpty()) {
            LOG.error(ERROR_TRANSLATING_POSTGRES_EXC_MSG, (Throwable)pSqlException);
            throw new RuntimeException(ERROR_TRANSLATING_EXCEPTION_MSG, (Throwable)pSqlException);
        }
        Set constraintViolations = entityTypeDependencyMap.entrySet().stream().map(entry -> {
            String message = ((Set)entry.getValue()).size() == 1 ? String.format("Cannot delete entity '%s' because entity '%s' depends on it.", entry.getKey(), ((Set)entry.getValue()).iterator().next()) : String.format("Cannot delete entity '%s' because entities '%s' depend on it.", entry.getKey(), ((Set)entry.getValue()).stream().collect(Collectors.joining(", ")));
            return new ConstraintViolation(message, null);
        }).collect(Collectors.toCollection(LinkedHashSet::new));
        return new MolgenisValidationException(constraintViolations);
    }

    static MolgenisValidationException translateInvalidIntegerException(PSQLException pSqlException) {
        String type;
        String postgreSqlType;
        ServerErrorMessage serverErrorMessage = pSqlException.getServerErrorMessage();
        String message = serverErrorMessage.getMessage();
        Matcher matcher = Pattern.compile("invalid input syntax for \\b(?:type )?\\b(.+?): \"(.*?)\"").matcher(message);
        boolean matches = matcher.matches();
        if (!matches) {
            throw new RuntimeException(ERROR_TRANSLATING_EXCEPTION_MSG, (Throwable)pSqlException);
        }
        switch (postgreSqlType = matcher.group(1)) {
            case "boolean": {
                type = AttributeType.BOOL.toString();
                break;
            }
            case "date": {
                type = AttributeType.DATE.toString();
                break;
            }
            case "timestamp with time zone": {
                type = AttributeType.DATE_TIME.toString();
                break;
            }
            case "double precision": {
                type = AttributeType.DECIMAL.toString();
                break;
            }
            case "integer": {
                type = AttributeType.INT.toString() + " or " + AttributeType.LONG.toString();
                break;
            }
            default: {
                type = postgreSqlType;
            }
        }
        String value = matcher.group(2);
        ConstraintViolation constraintViolation = new ConstraintViolation(String.format("Value [%s] of this entity attribute is not of type [%s].", value, type), null);
        return new MolgenisValidationException(Collections.singleton(constraintViolation));
    }

    MolgenisValidationException translateNotNullViolation(PSQLException pSqlException) {
        ServerErrorMessage serverErrorMessage = pSqlException.getServerErrorMessage();
        String tableName = serverErrorMessage.getTable();
        String message = serverErrorMessage.getMessage();
        Matcher matcher = Pattern.compile("null value in column \"?(.*?)\"? violates not-null constraint").matcher(message);
        boolean matches = matcher.matches();
        if (matches) {
            String columnName = matcher.group(1);
            EntityTypeDescription entityTypeDescription = this.entityTypeRegistry.getEntityTypeDescription(tableName);
            entityTypeDescription.getAttributeDescriptionMap().get((Object)columnName);
            ConstraintViolation constraintViolation = new ConstraintViolation(String.format("The attribute '%s' of entity '%s' can not be null.", this.tryGetAttributeName(tableName, columnName).orElse(TOKEN_UNKNOWN), this.tryGetEntityTypeName(tableName).orElse(TOKEN_UNKNOWN)), null);
            return new MolgenisValidationException(Collections.singleton(constraintViolation));
        }
        matcher = Pattern.compile("column \"(.*?)\" contains null values").matcher(message);
        matches = matcher.matches();
        if (!matches) {
            throw new RuntimeException(ERROR_TRANSLATING_EXCEPTION_MSG, (Throwable)pSqlException);
        }
        String columnName = matcher.group(1);
        ConstraintViolation constraintViolation = new ConstraintViolation(String.format("The attribute '%s' of entity '%s' contains null values.", this.tryGetAttributeName(tableName, columnName).orElse(TOKEN_UNKNOWN), this.tryGetEntityTypeName(tableName).orElse(TOKEN_UNKNOWN)), null);
        return new MolgenisValidationException(Collections.singleton(constraintViolation));
    }

    MolgenisValidationException translateForeignKeyViolation(PSQLException pSqlException) {
        String attrName;
        String constraintViolationMessageTemplate;
        ServerErrorMessage serverErrorMessage = pSqlException.getServerErrorMessage();
        String tableName = serverErrorMessage.getTable();
        String detailMessage = serverErrorMessage.getDetail();
        Matcher m = Pattern.compile("\\((.*?)\\)").matcher(detailMessage);
        if (!m.find()) {
            LOG.error(ERROR_TRANSLATING_POSTGRES_EXC_MSG, (Throwable)pSqlException);
            throw new RuntimeException(ERROR_TRANSLATING_EXCEPTION_MSG, (Throwable)pSqlException);
        }
        String colName = m.group(1);
        if (!m.find()) {
            LOG.error(ERROR_TRANSLATING_POSTGRES_EXC_MSG, (Throwable)pSqlException);
            throw new RuntimeException(ERROR_TRANSLATING_EXCEPTION_MSG, (Throwable)pSqlException);
        }
        String value = m.group(1);
        if (detailMessage.contains("still referenced from")) {
            constraintViolationMessageTemplate = "Value '%s' for attribute '%s' is referenced by entity '%s'.";
            String refTableName = this.getRefTableFromForeignKeyPsqlException(pSqlException);
            attrName = this.tryGetAttributeName(refTableName, colName).orElse(TOKEN_UNKNOWN);
        } else {
            constraintViolationMessageTemplate = "Unknown xref value '%s' for attribute '%s' of entity '%s'.";
            attrName = this.tryGetAttributeName(tableName, colName).orElse(TOKEN_UNKNOWN);
        }
        ConstraintViolation constraintViolation = new ConstraintViolation(String.format(constraintViolationMessageTemplate, value, attrName, this.tryGetEntityTypeName(tableName).orElse(TOKEN_UNKNOWN)), null);
        return new MolgenisValidationException(Collections.singleton(constraintViolation));
    }

    private String getRefTableFromForeignKeyPsqlException(PSQLException pSqlException) {
        ServerErrorMessage serverErrorMessage = pSqlException.getServerErrorMessage();
        Matcher messageMatcher = Pattern.compile("update or delete on table \"(.*)\" violates foreign key constraint \"(.*)\" on table \"(.*)\"").matcher(serverErrorMessage.getMessage());
        if (!messageMatcher.matches()) {
            LOG.error(ERROR_TRANSLATING_POSTGRES_EXC_MSG, (Throwable)pSqlException);
            throw new RuntimeException(ERROR_TRANSLATING_EXCEPTION_MSG, (Throwable)pSqlException);
        }
        return messageMatcher.group(1);
    }

    MolgenisValidationException translateUniqueKeyViolation(PSQLException pSqlException) {
        ServerErrorMessage serverErrorMessage = pSqlException.getServerErrorMessage();
        String tableName = serverErrorMessage.getTable();
        String detailMessage = serverErrorMessage.getDetail();
        Matcher matcher = Pattern.compile("Key \\(\"?(.*?)\"?\\)=\\((.*?)\\) already exists.").matcher(detailMessage);
        boolean matches = matcher.matches();
        if (matches) {
            ConstraintViolation constraintViolation;
            String[] columnNames = matcher.group(1).split(", ");
            if (columnNames.length == 1) {
                String columnName = columnNames[0];
                String value = matcher.group(2);
                constraintViolation = new ConstraintViolation(String.format("Duplicate value '%s' for unique attribute '%s' from entity '%s'.", value, this.tryGetAttributeName(tableName, columnName).orElse(TOKEN_UNKNOWN), this.tryGetEntityTypeName(tableName).orElse(TOKEN_UNKNOWN)), null);
            } else {
                String columnName = columnNames[columnNames.length - 1];
                String[] values = matcher.group(2).split(", ");
                String idValue = values[0];
                String value = values[1];
                constraintViolation = new ConstraintViolation(String.format("Duplicate list value '%s' for attribute '%s' from entity '%s' with id '%s'.", value, this.tryGetAttributeName(tableName, columnName).orElse(TOKEN_UNKNOWN), this.tryGetEntityTypeName(tableName).orElse(TOKEN_UNKNOWN), idValue), null);
            }
            return new MolgenisValidationException(Collections.singleton(constraintViolation));
        }
        matcher = Pattern.compile("Key \\(\"?(.*?)\"?\\)=\\((.*?)\\) is duplicated.").matcher(detailMessage);
        matches = matcher.matches();
        if (matches) {
            String columnName = matcher.group(1);
            String value = matcher.group(2);
            ConstraintViolation constraintViolation = new ConstraintViolation(String.format("The attribute '%s' of entity '%s' contains duplicate value '%s'.", this.tryGetAttributeName(tableName, columnName).orElse(TOKEN_UNKNOWN), this.tryGetEntityTypeName(tableName).orElse(TOKEN_UNKNOWN), value), null);
            return new MolgenisValidationException(Collections.singleton(constraintViolation));
        }
        LOG.error(ERROR_TRANSLATING_POSTGRES_EXC_MSG, (Throwable)pSqlException);
        throw new RuntimeException(ERROR_TRANSLATING_EXCEPTION_MSG, (Throwable)pSqlException);
    }

    MolgenisValidationException translateCheckConstraintViolation(PSQLException pSqlException) {
        ServerErrorMessage serverErrorMessage = pSqlException.getServerErrorMessage();
        String tableName = serverErrorMessage.getTable();
        String constraintName = serverErrorMessage.getConstraint();
        String columnName = constraintName.substring(tableName.length() + 1, constraintName.length() - 4);
        ConstraintViolation constraintViolation = new ConstraintViolation(String.format("Unknown enum value for attribute '%s' of entity '%s'.", this.tryGetAttributeName(tableName, columnName).orElse(TOKEN_UNKNOWN), this.tryGetEntityTypeName(tableName).orElse(TOKEN_UNKNOWN)), null);
        return new MolgenisValidationException(Collections.singleton(constraintViolation));
    }

    static MolgenisValidationException translateUndefinedColumnException(PSQLException pSqlException) {
        ServerErrorMessage serverErrorMessage = pSqlException.getServerErrorMessage();
        String message = serverErrorMessage.getMessage();
        ConstraintViolation constraintViolation = new ConstraintViolation(message);
        return new MolgenisValidationException(Collections.singleton(constraintViolation));
    }

    public MolgenisDataException doTranslate(TransactionException transactionException) {
        Throwable cause = transactionException.getCause();
        if (!(cause instanceof PSQLException)) {
            return null;
        }
        PSQLException pSqlException = (PSQLException)cause;
        return this.doTranslate(pSqlException);
    }

    private Optional<String> tryGetEntityTypeName(String tableName) {
        EntityTypeDescription entityTypeDescription = this.entityTypeRegistry.getEntityTypeDescription(tableName);
        String entityTypeId = entityTypeDescription != null ? entityTypeDescription.getId() : null;
        return Optional.ofNullable(entityTypeId);
    }

    private Optional<String> tryGetAttributeName(String tableName, String colName) {
        AttributeDescription attrDescription;
        EntityTypeDescription entityTypeDescription = this.entityTypeRegistry.getEntityTypeDescription(tableName);
        String attributeName = entityTypeDescription != null ? ((attrDescription = (AttributeDescription)entityTypeDescription.getAttributeDescriptionMap().get((Object)colName)) != null ? attrDescription.getName() : null) : null;
        return Optional.ofNullable(attributeName);
    }
}

