/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.postgresql;

import java.util.Objects;
import javax.sql.DataSource;
import org.molgenis.data.DataService;
import org.molgenis.data.RepositoryCollection;
import org.molgenis.data.postgresql.PostgreSqlEntityFactory;
import org.molgenis.data.postgresql.PostgreSqlExceptionTranslator;
import org.molgenis.data.postgresql.PostgreSqlRepositoryCollection;
import org.molgenis.data.postgresql.PostgreSqlRepositoryCollectionDecorator;
import org.molgenis.data.postgresql.identifier.EntityTypeRegistry;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.SQLExceptionTranslator;

@Configuration
public class PostgreSqlConfiguration {
    private final PostgreSqlEntityFactory postgreSqlEntityFactory;
    private final DataSource dataSource;
    private final DataService dataService;
    private final PostgreSqlExceptionTranslator postgreSqlExceptionTranslator;
    private final EntityTypeRegistry entityTypeRegistry;

    public PostgreSqlConfiguration(PostgreSqlEntityFactory postgreSqlEntityFactory, DataSource dataSource, DataService dataService, PostgreSqlExceptionTranslator postgreSqlExceptionTranslator, EntityTypeRegistry entityTypeRegistry) {
        this.postgreSqlEntityFactory = Objects.requireNonNull(postgreSqlEntityFactory);
        this.dataSource = Objects.requireNonNull(dataSource);
        this.dataService = Objects.requireNonNull(dataService);
        this.postgreSqlExceptionTranslator = Objects.requireNonNull(postgreSqlExceptionTranslator);
        this.entityTypeRegistry = Objects.requireNonNull(entityTypeRegistry);
    }

    @Bean
    public JdbcTemplate jdbcTemplate() {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        jdbcTemplate.setExceptionTranslator((SQLExceptionTranslator)this.postgreSqlExceptionTranslator);
        return jdbcTemplate;
    }

    @Bean
    public RepositoryCollection postgreSqlRepositoryCollection() {
        return new PostgreSqlRepositoryCollectionDecorator((RepositoryCollection)new PostgreSqlRepositoryCollection(this.postgreSqlEntityFactory, this.dataSource, this.jdbcTemplate(), this.dataService), this.entityTypeRegistry);
    }
}

