/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.postgresql;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.sql.DataSource;
import org.molgenis.data.Entity;
import org.molgenis.data.Fetch;
import org.molgenis.data.Query;
import org.molgenis.data.QueryRule;
import org.molgenis.data.RepositoryCapability;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.postgresql.PostgreSqlEntityFactory;
import org.molgenis.data.postgresql.PostgreSqlNameGenerator;
import org.molgenis.data.postgresql.PostgreSqlQueryGenerator;
import org.molgenis.data.postgresql.PostgreSqlQueryUtils;
import org.molgenis.data.postgresql.PostgreSqlUtils;
import org.molgenis.data.support.AbstractRepository;
import org.molgenis.data.support.BatchingQueryResult;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.data.util.EntityTypeUtils;
import org.molgenis.data.validation.MolgenisValidationException;
import org.molgenis.util.UnexpectedEnumException;
import org.molgenis.validation.ConstraintViolation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;

class PostgreSqlRepository
extends AbstractRepository {
    private static final Logger LOG = LoggerFactory.getLogger(PostgreSqlRepository.class);
    static final int BATCH_SIZE = 1000;
    private static final Set<RepositoryCapability> REPO_CAPABILITIES = Collections.unmodifiableSet(EnumSet.of(RepositoryCapability.WRITABLE, new RepositoryCapability[]{RepositoryCapability.MANAGABLE, RepositoryCapability.QUERYABLE, RepositoryCapability.VALIDATE_REFERENCE_CONSTRAINT, RepositoryCapability.VALIDATE_UNIQUE_CONSTRAINT, RepositoryCapability.VALIDATE_NOTNULL_CONSTRAINT, RepositoryCapability.VALIDATE_READONLY_CONSTRAINT, RepositoryCapability.CACHEABLE}));
    private static final Set<QueryRule.Operator> QUERY_OPERATORS = Collections.unmodifiableSet(EnumSet.of(QueryRule.Operator.EQUALS, new QueryRule.Operator[]{QueryRule.Operator.IN, QueryRule.Operator.LESS, QueryRule.Operator.LESS_EQUAL, QueryRule.Operator.GREATER, QueryRule.Operator.GREATER_EQUAL, QueryRule.Operator.RANGE, QueryRule.Operator.LIKE, QueryRule.Operator.NOT, QueryRule.Operator.AND, QueryRule.Operator.OR, QueryRule.Operator.NESTED}));
    private final PostgreSqlEntityFactory postgreSqlEntityFactory;
    private final JdbcTemplate jdbcTemplate;
    private final DataSource dataSource;
    private final EntityType entityType;

    PostgreSqlRepository(PostgreSqlEntityFactory postgreSqlEntityFactory, JdbcTemplate jdbcTemplate, DataSource dataSource, EntityType entityType) {
        this.postgreSqlEntityFactory = Objects.requireNonNull(postgreSqlEntityFactory);
        this.jdbcTemplate = Objects.requireNonNull(jdbcTemplate);
        this.dataSource = Objects.requireNonNull(dataSource);
        this.entityType = Objects.requireNonNull(entityType);
    }

    public Iterator<Entity> iterator() {
        QueryImpl q = new QueryImpl();
        return this.findAllBatching((Query<Entity>)q).iterator();
    }

    public Set<RepositoryCapability> getCapabilities() {
        return REPO_CAPABILITIES;
    }

    public Set<QueryRule.Operator> getQueryOperators() {
        return QUERY_OPERATORS;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public long count(Query<Entity> q) {
        ArrayList parameters = Lists.newArrayList();
        String sql = PostgreSqlQueryGenerator.getSqlCount(this.entityType, q, parameters);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Counting [{}] rows for query [{}]", (Object)this.getName(), q);
            if (LOG.isTraceEnabled()) {
                LOG.trace("SQL: {}, parameters: {}", (Object)sql, (Object)parameters);
            }
        }
        return (Long)this.jdbcTemplate.queryForObject(sql, parameters.toArray(new Object[parameters.size()]), Long.class);
    }

    public Stream<Entity> findAll(Query<Entity> q) {
        return StreamSupport.stream(this.findAllBatching(q).spliterator(), false);
    }

    public Entity findOne(Query<Entity> q) {
        Iterator iterator = this.findAll(q).iterator();
        if (iterator.hasNext()) {
            return (Entity)iterator.next();
        }
        return null;
    }

    public Entity findOneById(Object id) {
        if (id == null) {
            return null;
        }
        return this.findOne((Query<Entity>)new QueryImpl().eq(this.entityType.getIdAttribute().getName(), id));
    }

    public Entity findOneById(Object id, Fetch fetch) {
        if (id == null) {
            return null;
        }
        return this.findOne((Query<Entity>)new QueryImpl().eq(this.entityType.getIdAttribute().getName(), id).fetch(fetch));
    }

    public void update(Entity entity) {
        this.update(Stream.of(entity));
    }

    public void update(Stream<Entity> entities) {
        this.updateBatching(entities.iterator());
    }

    public void delete(Entity entity) {
        this.delete(Stream.of(entity));
    }

    public void delete(Stream<Entity> entities) {
        this.deleteAll(entities.map(Entity::getIdValue));
    }

    public void deleteById(Object id) {
        this.deleteAll(Stream.of(id));
    }

    public void deleteAll(Stream<Object> ids) {
        Iterators.partition(ids.iterator(), (int)1000).forEachRemaining(idsBatch -> {
            String sql = PostgreSqlQueryGenerator.getSqlDelete(this.entityType);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deleting {} [{}] entities", (Object)idsBatch.size(), (Object)this.getName());
                if (LOG.isTraceEnabled()) {
                    LOG.trace("SQL: {}", (Object)sql);
                }
            }
            this.jdbcTemplate.batchUpdate(sql, (BatchPreparedStatementSetter)new BatchDeletePreparedStatementSetter((List<Object>)idsBatch));
        });
    }

    public void deleteAll() {
        String deleteAllSql = PostgreSqlQueryGenerator.getSqlDeleteAll(this.entityType);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Deleting all [{}] entities", (Object)this.getName());
            if (LOG.isTraceEnabled()) {
                LOG.trace("SQL: {}", (Object)deleteAllSql);
            }
        }
        this.jdbcTemplate.update(deleteAllSql);
    }

    public void add(Entity entity) {
        if (entity == null) {
            throw new NullPointerException("PostgreSqlRepository.add() failed: entity was null");
        }
        this.add(Stream.of(entity));
    }

    public Integer add(Stream<Entity> entities) {
        return this.addBatching(entities.iterator());
    }

    public void forEachBatched(Fetch fetch, Consumer<List<Entity>> consumer, int batchSize) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        JdbcTemplate template = new JdbcTemplate(this.dataSource);
        template.setFetchSize(batchSize);
        QueryImpl query = new QueryImpl();
        if (fetch != null) {
            query.fetch(fetch);
        }
        String allRowsSelect = PostgreSqlQueryGenerator.getSqlSelect(this.entityType, query, Collections.emptyList(), false);
        LOG.debug("Fetching [{}] data...", (Object)this.getName());
        LOG.trace("SQL: {}", (Object)allRowsSelect);
        RowMapper<Entity> rowMapper = this.postgreSqlEntityFactory.createRowMapper(this.entityType, fetch);
        template.query(allRowsSelect, resultSet -> this.processResultSet(consumer, batchSize, this.entityType, rowMapper, resultSet));
        LOG.debug("Streamed entire repository in batches of size {} in {}.", (Object)batchSize, (Object)stopwatch);
    }

    private Object processResultSet(Consumer<List<Entity>> consumer, int batchSize, EntityType entityType, RowMapper<Entity> rowMapper, ResultSet resultSet) throws SQLException {
        int rowNum = 0;
        HashMap batch = Maps.newHashMap();
        while (resultSet.next()) {
            Entity entity = (Entity)rowMapper.mapRow(resultSet, rowNum++);
            batch.put(entity.getIdValue(), entity);
            if (rowNum % batchSize != 0) continue;
            this.handleBatch(consumer, entityType, batch);
            batch = Maps.newHashMap();
        }
        if (!batch.isEmpty()) {
            this.handleBatch(consumer, entityType, batch);
        }
        return null;
    }

    private void handleBatch(Consumer<List<Entity>> consumer, EntityType entityType, Map<Object, Entity> batch) {
        AttributeType idAttributeDataType = entityType.getIdAttribute().getDataType();
        LOG.debug("Select ID values for a batch of MREF attributes...");
        for (Attribute mrefAttr : entityType.getAtomicAttributes()) {
            if (mrefAttr.getExpression() != null || !EntityTypeUtils.isMultipleReferenceType((Attribute)mrefAttr) || mrefAttr.getDataType() == AttributeType.ONE_TO_MANY && mrefAttr.isMappedBy()) continue;
            EntityType refEntityType = mrefAttr.getRefEntity();
            Multimap<Object, Object> mrefIDs = this.selectMrefIDsForAttribute(entityType, idAttributeDataType, mrefAttr, batch.keySet(), refEntityType.getIdAttribute().getDataType());
            for (Map.Entry<Object, Entity> entry : batch.entrySet()) {
                batch.get(entry.getKey()).set(mrefAttr.getName(), this.postgreSqlEntityFactory.getReferences(refEntityType, Lists.newArrayList((Iterable)mrefIDs.get(entry.getKey()))));
            }
        }
        LOG.trace("Feeding batch of {} rows to consumer.", (Object)batch.size());
        consumer.accept(batch.values().stream().collect(Collectors.toList()));
    }

    private Multimap<Object, Object> selectMrefIDsForAttribute(EntityType entityType, AttributeType idAttributeDataType, Attribute mrefAttr, Set<Object> ids, AttributeType refIdDataType) {
        Stopwatch stopwatch = null;
        if (LOG.isTraceEnabled()) {
            stopwatch = Stopwatch.createStarted();
        }
        String junctionTableSelect = PostgreSqlQueryGenerator.getSqlJunctionTableSelect(entityType, mrefAttr, ids.size());
        LOG.trace("SQL: {}", (Object)junctionTableSelect);
        ArrayListMultimap mrefIDs = ArrayListMultimap.create();
        this.jdbcTemplate.query(junctionTableSelect, this.getJunctionTableRowCallbackHandler(idAttributeDataType, refIdDataType, (Multimap<Object, Object>)mrefIDs), ids.toArray());
        if (LOG.isTraceEnabled()) {
            LOG.trace("Selected {} ID values for MREF attribute {} in {}", new Object[]{mrefIDs.values().stream().collect(Collectors.counting()), mrefAttr.getName(), stopwatch});
        }
        return mrefIDs;
    }

    RowCallbackHandler getJunctionTableRowCallbackHandler(AttributeType idAttributeDataType, AttributeType refIdDataType, Multimap<Object, Object> mrefIDs) {
        return row -> {
            Object refId;
            Object id;
            switch (idAttributeDataType) {
                case EMAIL: 
                case HYPERLINK: 
                case STRING: {
                    id = row.getString(1);
                    break;
                }
                case INT: {
                    id = row.getInt(1);
                    break;
                }
                case LONG: {
                    id = row.getLong(1);
                    break;
                }
                default: {
                    throw new UnexpectedEnumException((Enum)idAttributeDataType);
                }
            }
            switch (refIdDataType) {
                case EMAIL: 
                case HYPERLINK: 
                case STRING: {
                    refId = row.getString(3);
                    break;
                }
                case INT: {
                    refId = row.getInt(3);
                    break;
                }
                case LONG: {
                    refId = row.getLong(3);
                    break;
                }
                default: {
                    throw new UnexpectedEnumException((Enum)refIdDataType);
                }
            }
            mrefIDs.put(id, refId);
        };
    }

    private BatchingQueryResult<Entity> findAllBatching(Query<Entity> q) {
        return new BatchingQueryResult<Entity>(1000, q){

            protected List<Entity> getBatch(Query<Entity> batchQuery) {
                ArrayList<Object> parameters = new ArrayList<Object>();
                String sql = PostgreSqlQueryGenerator.getSqlSelect(PostgreSqlRepository.this.getEntityType(), batchQuery, parameters, true);
                RowMapper<Entity> entityMapper = PostgreSqlRepository.this.postgreSqlEntityFactory.createRowMapper(PostgreSqlRepository.this.getEntityType(), batchQuery.getFetch());
                LOG.debug("Fetching [{}] data for query [{}]", (Object)PostgreSqlRepository.this.getName(), batchQuery);
                LOG.trace("SQL: {}, parameters: {}", (Object)sql, parameters);
                Stopwatch sw = Stopwatch.createStarted();
                List result = PostgreSqlRepository.this.jdbcTemplate.query(sql, parameters.toArray(new Object[parameters.size()]), entityMapper);
                LOG.trace("That took {}", (Object)sw);
                return result;
            }
        };
    }

    private Integer addBatching(Iterator<? extends Entity> entities) {
        AtomicInteger count = new AtomicInteger();
        Attribute idAttr = this.entityType.getIdAttribute();
        List tableAttrs = PostgreSqlQueryUtils.getTableAttributes(this.entityType).collect(Collectors.toList());
        List junctionTableAttrs = PostgreSqlQueryUtils.getJunctionTableAttributes(this.entityType).collect(Collectors.toList());
        String insertSql = PostgreSqlQueryGenerator.getSqlInsert(this.entityType);
        Iterators.partition(entities, (int)1000).forEachRemaining(entitiesBatch -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding {} [{}] entities", (Object)entitiesBatch.size(), (Object)this.getName());
                if (LOG.isTraceEnabled()) {
                    LOG.trace("SQL: {}", (Object)insertSql);
                }
            }
            this.jdbcTemplate.batchUpdate(insertSql, (BatchPreparedStatementSetter)new BatchAddPreparedStatementSetter((List<? extends Entity>)entitiesBatch, tableAttrs));
            if (!junctionTableAttrs.isEmpty()) {
                Map<String, List<Map<String, Object>>> mrefs = PostgreSqlRepository.createMrefMap(idAttr, junctionTableAttrs, entitiesBatch);
                for (Attribute attr : junctionTableAttrs) {
                    List<Map<String, Object>> attrMrefs = mrefs.get(attr.getName());
                    if (attrMrefs == null || attrMrefs.isEmpty()) continue;
                    this.addMrefs(attrMrefs, attr);
                }
            }
            count.addAndGet(entitiesBatch.size());
        });
        return count.get();
    }

    private static Map<String, List<Map<String, Object>>> createMrefMap(Attribute idAttr, List<Attribute> junctionTableAttrs, List<? extends Entity> entitiesBatch) {
        HashMap mrefs = Maps.newHashMapWithExpectedSize((int)junctionTableAttrs.size());
        AtomicInteger seqNr = new AtomicInteger();
        for (Entity entity : entitiesBatch) {
            for (Attribute attr : junctionTableAttrs) {
                Iterable refEntities = entity.getEntities(attr.getName());
                if (!attr.isNillable() && Iterables.isEmpty((Iterable)refEntities)) {
                    throw new MolgenisValidationException(new ConstraintViolation(String.format("The attribute [%s] of entity [%s] with id [%s] can not be null.", attr.getName(), attr.getEntity().getId(), entity.getIdValue().toString())));
                }
                mrefs.putIfAbsent(attr.getName(), new ArrayList());
                seqNr.set(0);
                for (Entity val : refEntities) {
                    Map<String, Object> mref = PostgreSqlRepository.createJunctionTableRowData(seqNr.getAndIncrement(), idAttr, val, attr, entity);
                    ((List)mrefs.get(attr.getName())).add(mref);
                }
            }
        }
        return mrefs;
    }

    static Map<String, Object> createJunctionTableRowData(int seqNr, Attribute idAttr, Entity refEntity, Attribute junctionTableAttr, Entity entity) {
        HashMap mref = Maps.newHashMapWithExpectedSize((int)3);
        mref.put(PostgreSqlNameGenerator.getJunctionTableOrderColumnName(), seqNr);
        mref.put(idAttr.getName(), entity.get(idAttr.getName()));
        mref.put(junctionTableAttr.getName(), refEntity);
        return mref;
    }

    private void updateBatching(Iterator<? extends Entity> entities) {
        Attribute idAttr = this.entityType.getIdAttribute();
        List tableAttrs = PostgreSqlQueryUtils.getTableAttributes(this.entityType).collect(Collectors.toList());
        List junctionTableAttrs = PostgreSqlQueryUtils.getJunctionTableAttributes(this.entityType).filter(attr -> !attr.isReadOnly()).collect(Collectors.toList());
        String updateSql = PostgreSqlQueryGenerator.getSqlUpdate(this.entityType);
        Iterators.partition(entities, (int)1000).forEachRemaining(entitiesBatch -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Updating {} [{}] entities", (Object)entitiesBatch.size(), (Object)this.getName());
                if (LOG.isTraceEnabled()) {
                    LOG.trace("SQL: {}", (Object)updateSql);
                }
            }
            int[] counts = this.jdbcTemplate.batchUpdate(updateSql, (BatchPreparedStatementSetter)new BatchUpdatePreparedStatementSetter((List<? extends Entity>)entitiesBatch, tableAttrs, idAttr));
            this.verifyUpdate((List<? extends Entity>)entitiesBatch, counts, idAttr);
            if (!junctionTableAttrs.isEmpty()) {
                Map<String, List<Map<String, Object>>> mrefs = PostgreSqlRepository.createMrefMap(idAttr, junctionTableAttrs, entitiesBatch);
                List<Object> ids = entitiesBatch.stream().map(entity -> PostgreSqlUtils.getPostgreSqlValue(entity, idAttr)).collect(Collectors.toList());
                for (Attribute attr : junctionTableAttrs) {
                    this.removeMrefs(ids, attr);
                    this.addMrefs(mrefs.get(attr.getName()), attr);
                }
            }
        });
    }

    private void verifyUpdate(List<? extends Entity> entitiesBatch, int[] counts, Attribute idAttr) {
        int nrUpdatedEntities = Arrays.stream(counts).sum();
        if (nrUpdatedEntities < entitiesBatch.size()) {
            Set existingEntityIds = this.findAll(entitiesBatch.stream().map(Entity::getIdValue), new Fetch().field(idAttr.getName())).map(Entity::getIdValue).collect(Collectors.toSet());
            Object nonExistingEntityId = entitiesBatch.stream().map(Entity::getIdValue).filter(entityId -> !existingEntityIds.contains(entityId)).findFirst().orElseThrow(() -> new IllegalStateException("Not all entities in batch were updated but all are present in the repository."));
            throw new MolgenisValidationException(new ConstraintViolation(String.format("Cannot update [%s] with id [%s] because it does not exist", this.entityType.getId(), nonExistingEntityId.toString())));
        }
    }

    void addMrefs(List<Map<String, Object>> mrefs, Attribute attr) {
        if (!attr.isNillable() && mrefs.isEmpty()) {
            throw new MolgenisValidationException(new ConstraintViolation(String.format("Entity [%s] attribute [%s] value cannot be null", this.entityType.getId(), attr.getName())));
        }
        Attribute idAttr = this.entityType.getIdAttribute();
        String insertMrefSql = PostgreSqlQueryGenerator.getSqlInsertJunction(this.entityType, attr);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding junction table entries for entity [{}] attribute [{}]", (Object)this.getName(), (Object)attr.getName());
            if (LOG.isTraceEnabled()) {
                LOG.trace("SQL: {}", (Object)insertMrefSql);
            }
        }
        try {
            this.jdbcTemplate.batchUpdate(insertMrefSql, (BatchPreparedStatementSetter)new BatchJunctionTableAddPreparedStatementSetter(mrefs, attr, idAttr));
        }
        catch (MolgenisValidationException mve) {
            if (mve.getMessage().equals("One of the values being added is too long.")) {
                mve = new MolgenisValidationException(new ConstraintViolation(String.format("One of the mref values in entity type [%s] attribute [%s] is too long.", this.getEntityType().getId(), attr.getName())));
            }
            throw mve;
        }
    }

    private void removeMrefs(List<Object> ids, Attribute attr) {
        Attribute idAttr = attr.isMappedBy() ? attr.getMappedBy() : this.entityType.getIdAttribute();
        String deleteMrefSql = PostgreSqlQueryGenerator.getSqlDelete(PostgreSqlNameGenerator.getJunctionTableName(this.entityType, attr), idAttr);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing junction table entries for entity [{}] attribute [{}]", (Object)this.getName(), (Object)attr.getName());
            if (LOG.isTraceEnabled()) {
                LOG.trace("SQL: {}", (Object)deleteMrefSql);
            }
        }
        this.jdbcTemplate.batchUpdate(deleteMrefSql, (BatchPreparedStatementSetter)new BatchJunctionTableDeletePreparedStatementSetter(ids));
    }

    private static class BatchJunctionTableDeletePreparedStatementSetter
    implements BatchPreparedStatementSetter {
        private final List<Object> entityIds;

        BatchJunctionTableDeletePreparedStatementSetter(List<Object> entityIds) {
            this.entityIds = entityIds;
        }

        public void setValues(PreparedStatement preparedStatement, int i) throws SQLException {
            preparedStatement.setObject(1, this.entityIds.get(i));
        }

        public int getBatchSize() {
            return this.entityIds.size();
        }
    }

    private static class BatchJunctionTableAddPreparedStatementSetter
    implements BatchPreparedStatementSetter {
        private final List<Map<String, Object>> mrefs;
        private final Attribute attr;
        private final Attribute idAttr;

        BatchJunctionTableAddPreparedStatementSetter(List<Map<String, Object>> mrefs, Attribute attr, Attribute idAttr) {
            this.mrefs = mrefs;
            this.attr = attr;
            this.idAttr = idAttr;
        }

        public void setValues(PreparedStatement preparedStatement, int i) throws SQLException {
            Object idValue1;
            Object idValue0;
            Map<String, Object> mref = this.mrefs.get(i);
            if (this.attr.isMappedBy()) {
                Entity mrefEntity = (Entity)mref.get(this.attr.getName());
                idValue0 = PostgreSqlUtils.getPostgreSqlValue(mrefEntity, this.attr.getRefEntity().getIdAttribute());
                idValue1 = mref.get(this.idAttr.getName());
            } else {
                idValue0 = mref.get(this.idAttr.getName());
                Entity mrefEntity = (Entity)mref.get(this.attr.getName());
                idValue1 = PostgreSqlUtils.getPostgreSqlValue(mrefEntity, mrefEntity.getEntityType().getIdAttribute());
            }
            preparedStatement.setInt(1, (Integer)mref.get(PostgreSqlNameGenerator.getJunctionTableOrderColumnName()));
            preparedStatement.setObject(2, idValue0);
            preparedStatement.setObject(3, idValue1);
        }

        public int getBatchSize() {
            return this.mrefs.size();
        }
    }

    private static class BatchDeletePreparedStatementSetter
    implements BatchPreparedStatementSetter {
        private final List<Object> entityIds;

        BatchDeletePreparedStatementSetter(List<Object> entityIds) {
            this.entityIds = entityIds;
        }

        public void setValues(PreparedStatement preparedStatement, int i) throws SQLException {
            preparedStatement.setObject(1, this.entityIds.get(i));
        }

        public int getBatchSize() {
            return this.entityIds.size();
        }
    }

    private static class BatchUpdatePreparedStatementSetter
    implements BatchPreparedStatementSetter {
        private final List<? extends Entity> entities;
        private final List<Attribute> tableAttrs;
        private final Attribute idAttr;

        BatchUpdatePreparedStatementSetter(List<? extends Entity> entities, List<Attribute> tableAttrs, Attribute idAttr) {
            this.entities = entities;
            this.tableAttrs = tableAttrs;
            this.idAttr = idAttr;
        }

        public void setValues(PreparedStatement preparedStatement, int rowIndex) throws SQLException {
            Entity entity = this.entities.get(rowIndex);
            int fieldIndex = 1;
            for (Attribute attr : this.tableAttrs) {
                Object postgreSqlValue = PostgreSqlUtils.getPostgreSqlValue(entity, attr);
                preparedStatement.setObject(fieldIndex++, postgreSqlValue);
            }
            preparedStatement.setObject(fieldIndex, PostgreSqlUtils.getPostgreSqlValue(entity, this.idAttr));
        }

        public int getBatchSize() {
            return this.entities.size();
        }
    }

    private static class BatchAddPreparedStatementSetter
    implements BatchPreparedStatementSetter {
        private final List<? extends Entity> entities;
        private final List<Attribute> tableAttrs;

        BatchAddPreparedStatementSetter(List<? extends Entity> entities, List<Attribute> tableAttrs) {
            this.entities = entities;
            this.tableAttrs = tableAttrs;
        }

        public void setValues(PreparedStatement preparedStatement, int rowIndex) throws SQLException {
            Entity entity = this.entities.get(rowIndex);
            int fieldIndex = 1;
            for (Attribute attr : this.tableAttrs) {
                Object postgreSqlValue = PostgreSqlUtils.getPostgreSqlValue(entity, attr);
                preparedStatement.setObject(fieldIndex++, postgreSqlValue);
            }
        }

        public int getBatchSize() {
            return this.entities.size();
        }
    }
}

