/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.postgresql;

import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.postgresql.PostgreSqlIdGenerator;

public class PostgreSqlNameGenerator {
    static final String JUNCTION_TABLE_ORDER_ATTR_NAME = "order";
    private static final int MAX_IDENTIFIER_BYTE_LENGTH = 63;

    private PostgreSqlNameGenerator() {
    }

    static String getTableName(EntityType entityType) {
        return PostgreSqlNameGenerator.getTableName(entityType, true);
    }

    public static String getTableName(EntityType entityType, boolean quotedIdentifier) {
        return PostgreSqlNameGenerator.getTableName(entityType, quotedIdentifier, 63);
    }

    private static String getTableName(EntityType entityType, boolean quotedIdentifier, int maxLength) {
        String identifier = new PostgreSqlIdGenerator(maxLength).generateId(entityType);
        return quotedIdentifier ? PostgreSqlNameGenerator.getQuotedIdentifier(identifier) : identifier;
    }

    static String getJunctionTableName(EntityType entityType, Attribute attr) {
        return PostgreSqlNameGenerator.getJunctionTableName(entityType, attr, true);
    }

    public static String getJunctionTableName(EntityType entityType, Attribute attr, boolean quotedIdentifier) {
        int nrAdditionalChars = 1;
        String entityPart = PostgreSqlNameGenerator.generateId(entityType, (63 - nrAdditionalChars) / 2);
        String attrPart = PostgreSqlNameGenerator.generateId(attr, (63 - nrAdditionalChars) / 2);
        return quotedIdentifier ? PostgreSqlNameGenerator.getQuotedIdentifier(entityPart + '_' + attrPart) : entityPart + '_' + attrPart;
    }

    static String getJunctionTableIndexName(EntityType entityType, Attribute attr, Attribute idxAttr) {
        String indexNamePostfix = "_idx";
        int nrAdditionalChars = 1 + indexNamePostfix.length();
        String entityPart = PostgreSqlNameGenerator.generateId(entityType, (63 - nrAdditionalChars) / 3);
        String attrPart = PostgreSqlNameGenerator.generateId(attr, (63 - nrAdditionalChars) / 3);
        String idxAttrPart = PostgreSqlNameGenerator.generateId(idxAttr, (63 - nrAdditionalChars) / 3);
        return PostgreSqlNameGenerator.getQuotedIdentifier(entityPart + '_' + attrPart + '_' + idxAttrPart + indexNamePostfix);
    }

    static String getColumnName(Attribute attr) {
        return PostgreSqlNameGenerator.getColumnName(attr, true);
    }

    public static String getColumnName(Attribute attr, boolean quotedIdentifier) {
        String identifier = PostgreSqlNameGenerator.generateId(attr, 63);
        return quotedIdentifier ? PostgreSqlNameGenerator.getQuotedIdentifier(identifier) : identifier;
    }

    static String getJunctionTableOrderColumnName() {
        return PostgreSqlNameGenerator.getQuotedIdentifier(JUNCTION_TABLE_ORDER_ATTR_NAME);
    }

    static String getFilterColumnName(Attribute attr, int filterIndex) {
        String filterPostfix = "filter" + filterIndex;
        int nrAdditionalChars = 1 + filterPostfix.length();
        String attrId = PostgreSqlNameGenerator.generateId(attr, 63 - nrAdditionalChars);
        return PostgreSqlNameGenerator.getQuotedIdentifier(attrId + '_' + filterPostfix);
    }

    static String getPrimaryKeyName(EntityType entityType, Attribute attr) {
        return PostgreSqlNameGenerator.getConstraintName(entityType, attr, "pkey");
    }

    static String getForeignKeyName(EntityType entityType, Attribute attr) {
        return PostgreSqlNameGenerator.getConstraintName(entityType, attr, "fkey");
    }

    static String getUniqueKeyName(EntityType entityType, Attribute attr) {
        return PostgreSqlNameGenerator.getConstraintName(entityType, attr, "key");
    }

    static String getCheckConstraintName(EntityType entityType, Attribute attr) {
        return PostgreSqlNameGenerator.getConstraintName(entityType, attr, "chk");
    }

    private static String getConstraintName(EntityType entityType, Attribute attr, String constraintPostfix) {
        int nrAdditionalChars = 2 + constraintPostfix.length();
        String entityPart = PostgreSqlNameGenerator.generateId(entityType, (63 - nrAdditionalChars) / 2);
        String attrPart = PostgreSqlNameGenerator.generateId(attr, (63 - nrAdditionalChars) / 2);
        return PostgreSqlNameGenerator.getQuotedIdentifier(entityPart + '_' + attrPart + '_' + constraintPostfix);
    }

    static String getFunctionValidateUpdateName(EntityType entityType) {
        String prefix = "validate_update";
        int maxLength = 63 - prefix.length() - 1;
        return PostgreSqlNameGenerator.getQuotedIdentifier(prefix + '_' + PostgreSqlNameGenerator.getTableName(entityType, false, maxLength));
    }

    static String getUpdateTriggerName(EntityType entityType) {
        String prefix = "update_trigger";
        int maxLength = 63 - prefix.length() - 1;
        String identifier = prefix + '_' + PostgreSqlNameGenerator.getTableName(entityType, false, maxLength);
        return PostgreSqlNameGenerator.getQuotedIdentifier(identifier);
    }

    private static String getQuotedIdentifier(String identifier) {
        return '\"' + identifier + '\"';
    }

    private static String generateId(EntityType entityType, int maxByteLength) {
        return new PostgreSqlIdGenerator(maxByteLength).generateId(entityType);
    }

    private static String generateId(Attribute attr, int maxByteLength) {
        return new PostgreSqlIdGenerator(maxByteLength).generateId(attr);
    }
}

