/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.postgresql;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityManager;
import org.molgenis.data.Fetch;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.IllegalAttributeTypeException;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.postgresql.PostgreSqlNameGenerator;
import org.molgenis.data.util.MolgenisDateFormat;
import org.molgenis.util.UnexpectedEnumException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Component
class PostgreSqlEntityFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PostgreSqlEntityFactory.class);
    private final EntityManager entityManager;

    public PostgreSqlEntityFactory(EntityManager entityManager) {
        this.entityManager = Objects.requireNonNull(entityManager);
    }

    RowMapper<Entity> createRowMapper(EntityType entityType, Fetch fetch) {
        return new EntityMapper(this.entityManager, entityType, fetch);
    }

    Iterable<Entity> getReferences(EntityType refEntityType, Iterable<?> ids) {
        return this.entityManager.getReferences(refEntityType, ids);
    }

    private static class EntityMapper
    implements RowMapper<Entity> {
        private final EntityManager entityManager;
        private final EntityType entityType;
        private final Fetch fetch;

        private EntityMapper(EntityManager entityManager, EntityType entityType, Fetch fetch) {
            this.entityManager = Objects.requireNonNull(entityManager);
            this.entityType = Objects.requireNonNull(entityType);
            this.fetch = fetch;
        }

        public Entity mapRow(ResultSet resultSet, int i) throws SQLException {
            Entity e = this.entityManager.createFetch(this.entityType, this.fetch);
            for (Attribute attr : this.entityType.getAtomicAttributes()) {
                if (this.fetch != null && !this.fetch.hasField(attr.getName()) || attr.getExpression() != null) continue;
                e.set(attr.getName(), this.mapValue(resultSet, attr));
            }
            return e;
        }

        private Object mapValue(ResultSet resultSet, Attribute attr) throws SQLException {
            return this.mapValue(resultSet, attr, PostgreSqlNameGenerator.getColumnName(attr, false));
        }

        private Object mapValue(ResultSet resultSet, Attribute attr, String colName) throws SQLException {
            Object value;
            switch (attr.getDataType()) {
                case BOOL: {
                    boolean boolValue = resultSet.getBoolean(colName);
                    value = resultSet.wasNull() ? null : Boolean.valueOf(boolValue);
                    break;
                }
                case CATEGORICAL: 
                case FILE: 
                case XREF: {
                    EntityType xrefEntityType = attr.getRefEntity();
                    Object refIdValue = this.mapValue(resultSet, xrefEntityType.getIdAttribute(), colName);
                    value = refIdValue != null ? this.entityManager.getReference(xrefEntityType, refIdValue) : null;
                    break;
                }
                case CATEGORICAL_MREF: 
                case MREF: {
                    EntityType mrefEntityMeta = attr.getRefEntity();
                    Array mrefArrayValue = resultSet.getArray(colName);
                    value = resultSet.wasNull() ? null : this.mapValueMref(mrefArrayValue, mrefEntityMeta);
                    break;
                }
                case ONE_TO_MANY: {
                    Array oneToManyArrayValue = resultSet.getArray(colName);
                    value = resultSet.wasNull() ? null : this.mapValueOneToMany(oneToManyArrayValue, attr);
                    break;
                }
                case COMPOUND: {
                    throw new IllegalAttributeTypeException(attr.getDataType());
                }
                case DATE: {
                    value = resultSet.getObject(colName, LocalDate.class);
                    break;
                }
                case DATE_TIME: {
                    OffsetDateTime offsetDateTime = resultSet.getObject(colName, OffsetDateTime.class);
                    value = resultSet.wasNull() ? null : offsetDateTime.toInstant();
                    break;
                }
                case DECIMAL: {
                    BigDecimal bigDecimalValue = resultSet.getBigDecimal(colName);
                    value = bigDecimalValue != null ? Double.valueOf(bigDecimalValue.doubleValue()) : null;
                    break;
                }
                case EMAIL: 
                case ENUM: 
                case HTML: 
                case HYPERLINK: 
                case SCRIPT: 
                case STRING: 
                case TEXT: {
                    value = resultSet.getString(colName);
                    break;
                }
                case INT: {
                    int intValue = resultSet.getInt(colName);
                    value = resultSet.wasNull() ? null : Integer.valueOf(intValue);
                    break;
                }
                case LONG: {
                    long longValue = resultSet.getLong(colName);
                    value = resultSet.wasNull() ? null : Long.valueOf(longValue);
                    break;
                }
                default: {
                    throw new UnexpectedEnumException((Enum)attr.getDataType());
                }
            }
            return value;
        }

        private Object mapValueOneToMany(Array arrayValue, Attribute attr) throws SQLException {
            Iterable value;
            EntityType refEntityType = attr.getRefEntity();
            Object[] postgreSqlMrefIds = (Object[])arrayValue.getArray();
            if (postgreSqlMrefIds.length > 0 && postgreSqlMrefIds[0] != null) {
                Attribute idAttr = refEntityType.getIdAttribute();
                Object[] mrefIds = new Object[postgreSqlMrefIds.length];
                for (int i = 0; i < postgreSqlMrefIds.length; ++i) {
                    Object mrefId;
                    Object mrefIdRaw = postgreSqlMrefIds[i];
                    mrefIds[i] = mrefId = mrefIdRaw != null ? EntityMapper.convertMrefIdValue(mrefIdRaw.toString(), idAttr) : null;
                }
                value = this.entityManager.getReferences(refEntityType, Arrays.asList(mrefIds));
            } else {
                value = null;
            }
            return value;
        }

        private Object mapValueMref(Array arrayValue, EntityType entityType) throws SQLException {
            Iterable value;
            String[][] mrefIdsAndOrder = (String[][])arrayValue.getArray();
            if (mrefIdsAndOrder.length > 0 && mrefIdsAndOrder[0][0] != null) {
                Arrays.sort(mrefIdsAndOrder, Comparator.comparing(o -> Integer.valueOf(o[0])));
                Attribute idAttr = entityType.getIdAttribute();
                Object[] mrefIds = new Object[mrefIdsAndOrder.length];
                for (int i = 0; i < mrefIdsAndOrder.length; ++i) {
                    Object mrefId;
                    String[] mrefIdAndOrder = mrefIdsAndOrder[i];
                    String mrefIdStr = mrefIdAndOrder[1];
                    mrefIds[i] = mrefId = mrefIdStr != null ? EntityMapper.convertMrefIdValue(mrefIdStr, idAttr) : null;
                }
                value = this.entityManager.getReferences(entityType, Arrays.asList(mrefIds));
            } else {
                value = null;
            }
            return value;
        }

        private static Object convertMrefIdValue(String idValueStr, Attribute idAttr) {
            AttributeType attrType;
            block11: while (true) {
                attrType = idAttr.getDataType();
                switch (attrType) {
                    case BOOL: {
                        return Boolean.valueOf(idValueStr);
                    }
                    case CATEGORICAL: 
                    case FILE: 
                    case XREF: {
                        idAttr = idAttr.getRefEntity().getIdAttribute();
                        continue block11;
                    }
                    case DATE: {
                        return MolgenisDateFormat.parseLocalDate((String)idValueStr);
                    }
                    case DATE_TIME: {
                        return MolgenisDateFormat.parseInstant((String)idValueStr).atOffset(ZoneOffset.UTC);
                    }
                    case DECIMAL: {
                        return Double.valueOf(idValueStr);
                    }
                    case EMAIL: 
                    case ENUM: 
                    case HTML: 
                    case HYPERLINK: 
                    case SCRIPT: 
                    case STRING: 
                    case TEXT: {
                        return idValueStr;
                    }
                    case INT: {
                        return Integer.valueOf(idValueStr);
                    }
                    case LONG: {
                        return Long.valueOf(idValueStr);
                    }
                    case CATEGORICAL_MREF: 
                    case MREF: 
                    case ONE_TO_MANY: 
                    case COMPOUND: {
                        throw new IllegalAttributeTypeException(attrType);
                    }
                }
                break;
            }
            throw new UnexpectedEnumException((Enum)attrType);
        }
    }
}

