/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.postgresql;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.beans.PropertyVetoException;
import java.util.Objects;
import java.util.Properties;
import javax.sql.DataSource;
import org.molgenis.data.config.DataSourceConfig;
import org.molgenis.data.populate.IdGenerator;
import org.molgenis.data.postgresql.transaction.PostgreSqlTransactionManager;
import org.molgenis.data.transaction.TransactionExceptionTranslatorRegistry;
import org.molgenis.data.transaction.TransactionManager;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.TransactionManagementConfigurer;

@Configuration
@EnableTransactionManagement(proxyTargetClass=true)
@Import(value={DataSourceConfig.class})
public class DatabaseConfig
implements TransactionManagementConfigurer {
    private static final int MAX_POOL_SIZE = 95;
    @Value(value="${db_driver:org.postgresql.Driver}")
    private String dbDriverClass;
    @Value(value="${db_uri:@null}")
    private String dbJdbcUri;
    @Value(value="${db_user:@null}")
    private String dbUser;
    @Value(value="${db_password:@null}")
    private String dbPassword;
    private final IdGenerator idGenerator;
    private final TransactionExceptionTranslatorRegistry transactionExceptionTranslatorRegistry;

    public DatabaseConfig(IdGenerator idGenerator, TransactionExceptionTranslatorRegistry transactionExceptionTranslatorRegistry) {
        this.idGenerator = Objects.requireNonNull(idGenerator);
        this.transactionExceptionTranslatorRegistry = Objects.requireNonNull(transactionExceptionTranslatorRegistry);
    }

    @Bean
    public DataSource dataSource() {
        if (this.dbDriverClass == null) {
            throw new IllegalArgumentException("db_driver is null");
        }
        if (this.dbJdbcUri == null) {
            throw new IllegalArgumentException("db_uri is null");
        }
        if (this.dbUser == null) {
            throw new IllegalArgumentException("please configure the db_user property in your molgenis-server.properties");
        }
        if (this.dbPassword == null) {
            throw new IllegalArgumentException("please configure the db_password property in your molgenis-server.properties");
        }
        ComboPooledDataSource dataSource = new ComboPooledDataSource();
        try {
            dataSource.setDriverClass(this.dbDriverClass);
        }
        catch (PropertyVetoException e) {
            throw new RuntimeException(e);
        }
        dataSource.setJdbcUrl(this.dbJdbcUri);
        dataSource.setUser(this.dbUser);
        dataSource.setPassword(this.dbPassword);
        dataSource.setInitialPoolSize(5);
        dataSource.setMinPoolSize(5);
        dataSource.setMaxPoolSize(95);
        dataSource.setTestConnectionOnCheckin(true);
        dataSource.setIdleConnectionTestPeriod(120);
        Properties properties = dataSource.getProperties();
        properties.setProperty("reWriteBatchedInserts", "true");
        properties.setProperty("autosave", "CONSERVATIVE");
        dataSource.setProperties(properties);
        return dataSource;
    }

    @Bean
    public TransactionManager transactionManager() {
        return new PostgreSqlTransactionManager(this.idGenerator, this.dataSource(), this.transactionExceptionTranslatorRegistry);
    }

    public PlatformTransactionManager annotationDrivenTransactionManager() {
        return this.transactionManager();
    }
}

