/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.postgresql;

import java.util.Objects;
import org.molgenis.data.AbstractRepositoryCollectionDecorator;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.data.RepositoryCollection;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.postgresql.identifier.EntityTypeRegistry;

public class PostgreSqlRepositoryCollectionDecorator
extends AbstractRepositoryCollectionDecorator {
    private final EntityTypeRegistry entityTypeRegistry;

    PostgreSqlRepositoryCollectionDecorator(RepositoryCollection delegateRepositoryCollection, EntityTypeRegistry entityTypeRegistry) {
        super(delegateRepositoryCollection);
        this.entityTypeRegistry = Objects.requireNonNull(entityTypeRegistry);
    }

    public Repository<Entity> createRepository(EntityType entityType) {
        Repository repo = this.delegate().createRepository(entityType);
        this.entityTypeRegistry.registerEntityType(entityType);
        return repo;
    }

    public void deleteRepository(EntityType entityType) {
        this.delegate().deleteRepository(entityType);
        this.entityTypeRegistry.unregisterEntityType(entityType);
    }

    public void updateRepository(EntityType entityType, EntityType updatedEntityType) {
        this.delegate().updateRepository(entityType, updatedEntityType);
        this.entityTypeRegistry.registerEntityType(updatedEntityType);
    }

    public void addAttribute(EntityType entityType, Attribute attribute) {
        this.entityTypeRegistry.addAttribute(entityType, attribute);
        this.delegate().addAttribute(entityType, attribute);
    }

    public void updateAttribute(EntityType entityType, Attribute attr, Attribute updatedAttr) {
        this.entityTypeRegistry.updateAttribute(entityType, attr, updatedAttr);
        this.delegate().updateAttribute(entityType, attr, updatedAttr);
    }

    public void deleteAttribute(EntityType entityType, Attribute attr) {
        this.entityTypeRegistry.deleteAttribute(entityType, attr);
        this.delegate().deleteAttribute(entityType, attr);
    }
}

