/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.postgresql;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.file.model.FileMeta;

class PostgreSqlUtils {
    private PostgreSqlUtils() {
    }

    static Object getPostgreSqlValue(Entity entity, Attribute attr) {
        String attrName = attr.getName();
        AttributeType attrType = attr.getDataType();
        switch (attrType) {
            case BOOL: {
                return entity.getBoolean(attrName);
            }
            case CATEGORICAL: 
            case XREF: {
                Entity xrefEntity = entity.getEntity(attrName);
                return xrefEntity != null ? PostgreSqlUtils.getPostgreSqlValue(xrefEntity, xrefEntity.getEntityType().getIdAttribute()) : null;
            }
            case CATEGORICAL_MREF: 
            case MREF: 
            case ONE_TO_MANY: {
                Iterable entities = entity.getEntities(attrName);
                return StreamSupport.stream(entities.spliterator(), false).map(mrefEntity -> PostgreSqlUtils.getPostgreSqlValue(mrefEntity, mrefEntity.getEntityType().getIdAttribute())).collect(Collectors.toList());
            }
            case DATE: {
                return entity.getLocalDate(attrName);
            }
            case DATE_TIME: {
                Instant instant = entity.getInstant(attrName);
                return instant != null ? instant.truncatedTo(ChronoUnit.SECONDS).atOffset(ZoneOffset.UTC) : null;
            }
            case DECIMAL: {
                return entity.getDouble(attrName);
            }
            case EMAIL: 
            case ENUM: 
            case HTML: 
            case HYPERLINK: 
            case SCRIPT: 
            case STRING: 
            case TEXT: {
                return entity.getString(attrName);
            }
            case FILE: {
                FileMeta fileEntity = (FileMeta)entity.getEntity(attrName, FileMeta.class);
                return fileEntity != null ? PostgreSqlUtils.getPostgreSqlValue((Entity)fileEntity, fileEntity.getEntityType().getIdAttribute()) : null;
            }
            case INT: {
                return entity.getInt(attrName);
            }
            case LONG: {
                return entity.getLong(attrName);
            }
            case COMPOUND: {
                throw new RuntimeException(String.format("Illegal attribute type [%s]", attrType.toString()));
            }
        }
        throw new RuntimeException(String.format("Unknown attribute type [%s]", attrType.toString()));
    }

    static Object getPostgreSqlQueryValue(Object queryValue, Attribute attr) {
        AttributeType attrType;
        block12: while (true) {
            String attrName = attr.getName();
            attrType = attr.getDataType();
            switch (attrType) {
                case BOOL: {
                    if (queryValue != null && !(queryValue instanceof Boolean)) {
                        throw new MolgenisDataException(String.format("Attribute [%s] query value is of type [%s] instead of [%s]", attrName, queryValue.getClass().getSimpleName(), Boolean.class.getSimpleName()));
                    }
                    return queryValue;
                }
                case CATEGORICAL: 
                case XREF: 
                case CATEGORICAL_MREF: 
                case MREF: 
                case ONE_TO_MANY: 
                case FILE: {
                    if (queryValue != null) {
                        if (queryValue instanceof Entity) {
                            queryValue = ((Entity)queryValue).getIdValue();
                        }
                        attr = attr.getRefEntity().getIdAttribute();
                        continue block12;
                    }
                    return null;
                }
                case DATE: {
                    if (queryValue != null && !(queryValue instanceof LocalDate)) {
                        throw new MolgenisDataException(String.format("Attribute [%s] query value is of type [%s] instead of [%s]", attrName, queryValue.getClass().getSimpleName(), LocalDate.class.getSimpleName()));
                    }
                    return queryValue;
                }
                case DATE_TIME: {
                    if (queryValue == null) {
                        return null;
                    }
                    if (!(queryValue instanceof Instant)) {
                        throw new MolgenisDataException(String.format("Attribute [%s] query value is of type [%s] instead of [%s]", attrName, queryValue.getClass().getSimpleName(), Instant.class.getSimpleName()));
                    }
                    return ((Instant)queryValue).atOffset(ZoneOffset.UTC);
                }
                case DECIMAL: {
                    if (queryValue != null && !(queryValue instanceof Double)) {
                        throw new MolgenisDataException(String.format("Attribute [%s] query value is of type [%s] instead of [%s]", attrName, queryValue.getClass().getSimpleName(), Double.class.getSimpleName()));
                    }
                    return queryValue;
                }
                case ENUM: {
                    if (queryValue != null) {
                        if (queryValue instanceof String) {
                            return queryValue;
                        }
                        if (queryValue instanceof Enum) {
                            return queryValue.toString();
                        }
                        throw new MolgenisDataException(String.format("Attribute [%s] query value is of type [%s] instead of [%s] or [%s]", attrName, queryValue.getClass().getSimpleName(), String.class.getSimpleName(), Enum.class.getSimpleName()));
                    }
                    return null;
                }
                case EMAIL: 
                case HTML: 
                case HYPERLINK: 
                case SCRIPT: 
                case STRING: 
                case TEXT: {
                    if (queryValue != null && !(queryValue instanceof String)) {
                        throw new MolgenisDataException(String.format("Attribute [%s] query value is of type [%s] instead of [%s]", attrName, queryValue.getClass().getSimpleName(), String.class.getSimpleName()));
                    }
                    return queryValue;
                }
                case INT: {
                    if (queryValue != null && !(queryValue instanceof Integer)) {
                        throw new MolgenisDataException(String.format("Attribute [%s] query value is of type [%s] instead of [%s]", attrName, queryValue.getClass().getSimpleName(), Integer.class.getSimpleName()));
                    }
                    return queryValue;
                }
                case LONG: {
                    if (queryValue != null && !(queryValue instanceof Long)) {
                        throw new MolgenisDataException(String.format("Attribute [%s] query value is of type [%s] instead of [%s]", attrName, queryValue.getClass().getSimpleName(), Long.class.getSimpleName()));
                    }
                    return queryValue;
                }
                case COMPOUND: {
                    throw new RuntimeException(String.format("Illegal attribute type [%s]", attrType.toString()));
                }
            }
            break;
        }
        throw new RuntimeException(String.format("Unknown attribute type [%s]", attrType.toString()));
    }
}

