/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.postgresql;

import java.util.Objects;
import org.molgenis.data.AbstractRepositoryCollectionDecorator;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.data.RepositoryCollection;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.util.AttributeCopier;
import org.molgenis.data.meta.util.EntityTypeCopier;
import org.molgenis.data.postgresql.identifier.EntityTypeRegistry;

public class PostgreSqlRepositoryCollectionDecorator
extends AbstractRepositoryCollectionDecorator {
    private final EntityTypeRegistry entityTypeRegistry;
    private final EntityTypeCopier entityTypeCopier;
    private final AttributeCopier attributeCopier;

    PostgreSqlRepositoryCollectionDecorator(RepositoryCollection delegateRepositoryCollection, EntityTypeRegistry entityTypeRegistry, EntityTypeCopier entityTypeCopier, AttributeCopier attributeCopier) {
        super(delegateRepositoryCollection);
        this.entityTypeRegistry = Objects.requireNonNull(entityTypeRegistry);
        this.entityTypeCopier = Objects.requireNonNull(entityTypeCopier);
        this.attributeCopier = Objects.requireNonNull(attributeCopier);
    }

    public Repository<Entity> createRepository(EntityType entityType) {
        Repository repo = this.delegate().createRepository(entityType);
        this.entityTypeRegistry.registerEntityType(entityType);
        return repo;
    }

    public void deleteRepository(EntityType entityType) {
        this.delegate().deleteRepository(entityType);
        this.entityTypeRegistry.unregisterEntityType(entityType);
    }

    public void updateRepository(EntityType entityType, EntityType updatedEntityType) {
        this.delegate().updateRepository(entityType, updatedEntityType);
        this.entityTypeRegistry.registerEntityType(updatedEntityType);
    }

    public void addAttribute(EntityType entityType, Attribute attribute) {
        EntityType updatedEntityType = this.entityTypeCopier.copy(entityType);
        Attribute attributeCopy = this.attributeCopier.copy(attribute);
        updatedEntityType.addAttribute(attributeCopy, new EntityType.AttributeRole[0]);
        this.entityTypeRegistry.registerEntityType(updatedEntityType);
        this.delegate().addAttribute(entityType, attribute);
    }

    public void updateAttribute(EntityType entityType, Attribute attr, Attribute updatedAttr) {
        EntityType updatedEntityType = this.entityTypeCopier.copy(entityType);
        Attribute updatedAttributeCopy = this.attributeCopier.copy(updatedAttr);
        updatedEntityType.removeAttribute(attr);
        updatedEntityType.addAttribute(updatedAttributeCopy, new EntityType.AttributeRole[0]);
        this.entityTypeRegistry.registerEntityType(updatedEntityType);
        this.delegate().updateAttribute(entityType, attr, updatedAttr);
    }

    public void deleteAttribute(EntityType entityType, Attribute attr) {
        EntityType updatedEntityType = this.entityTypeCopier.copy(entityType);
        updatedEntityType.removeAttribute(attr);
        this.entityTypeRegistry.registerEntityType(updatedEntityType);
        this.delegate().deleteAttribute(entityType, attr);
    }
}

