/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.postgresql;

import com.google.common.collect.Sets;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.Repository;
import org.molgenis.data.RepositoryCollectionCapability;
import org.molgenis.data.UnknownAttributeException;
import org.molgenis.data.UnknownRepositoryException;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.MetaUtils;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.postgresql.PostgreSqlEntityFactory;
import org.molgenis.data.postgresql.PostgreSqlNameGenerator;
import org.molgenis.data.postgresql.PostgreSqlQueryGenerator;
import org.molgenis.data.postgresql.PostgreSqlQueryUtils;
import org.molgenis.data.postgresql.PostgreSqlRepository;
import org.molgenis.data.support.AbstractRepositoryCollection;
import org.molgenis.data.support.EntityTypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class PostgreSqlRepositoryCollection
extends AbstractRepositoryCollection {
    private static final Logger LOG = LoggerFactory.getLogger(PostgreSqlRepositoryCollection.class);
    public static final String POSTGRESQL = "PostgreSQL";
    private final PostgreSqlEntityFactory postgreSqlEntityFactory;
    private final DataSource dataSource;
    private final JdbcTemplate jdbcTemplate;
    private final DataService dataService;

    PostgreSqlRepositoryCollection(PostgreSqlEntityFactory postgreSqlEntityFactory, DataSource dataSource, JdbcTemplate jdbcTemplate, DataService dataService) {
        this.postgreSqlEntityFactory = Objects.requireNonNull(postgreSqlEntityFactory);
        this.dataSource = Objects.requireNonNull(dataSource);
        this.jdbcTemplate = Objects.requireNonNull(jdbcTemplate);
        this.dataService = Objects.requireNonNull(dataService);
    }

    public String getName() {
        return POSTGRESQL;
    }

    public Set<RepositoryCollectionCapability> getCapabilities() {
        return Sets.immutableEnumSet(EnumSet.of(RepositoryCollectionCapability.WRITABLE, RepositoryCollectionCapability.UPDATABLE, RepositoryCollectionCapability.META_DATA_PERSISTABLE));
    }

    public boolean hasRepository(String name) {
        throw new UnsupportedOperationException();
    }

    public Repository<Entity> createRepository(EntityType entityType) {
        PostgreSqlRepository repository = this.createPostgreSqlRepository();
        repository.setEntityType(entityType);
        if (!this.isTableExists(entityType)) {
            this.createTable(entityType);
        }
        return repository;
    }

    public boolean hasRepository(EntityType entityType) {
        return this.isTableExists(entityType);
    }

    public Iterable<String> getEntityTypeIds() {
        return this.dataService.query("sys_md_EntityType", EntityType.class).eq("backend", (Object)POSTGRESQL).fetch(MetaUtils.getEntityTypeFetch()).findAll().map(EntityType::getId)::iterator;
    }

    public Repository<Entity> getRepository(String id) {
        EntityType entityType = (EntityType)this.dataService.query("sys_md_EntityType", EntityType.class).eq("backend", (Object)POSTGRESQL).and().eq("id", (Object)id).and().eq("isAbstract", (Object)false).fetch(MetaUtils.getEntityTypeFetch()).findOne();
        return this.getRepository(entityType);
    }

    public Repository<Entity> getRepository(EntityType entityType) {
        PostgreSqlRepository repository = this.createPostgreSqlRepository();
        repository.setEntityType(entityType);
        return repository;
    }

    public Iterator<Repository<Entity>> iterator() {
        return this.dataService.query("sys_md_EntityType", EntityType.class).eq("backend", (Object)POSTGRESQL).and().eq("isAbstract", (Object)false).fetch(MetaUtils.getEntityTypeFetch()).findAll().map(this::getRepository).iterator();
    }

    public void deleteRepository(EntityType entityType) {
        if (entityType.isAbstract()) {
            throw new UnknownRepositoryException(entityType.getId());
        }
        this.dropTables(entityType);
    }

    public void updateRepository(EntityType entityType, EntityType updatedEntityType) {
    }

    private void dropTables(EntityType entityType) {
        PostgreSqlQueryUtils.getJunctionTableAttributes(entityType).forEach(mrefAttr -> this.dropJunctionTable(entityType, (Attribute)mrefAttr));
        String sqlDropTable = PostgreSqlQueryGenerator.getSqlDropTable(entityType);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Dropping table for entity [{}]", (Object)entityType.getId());
            if (LOG.isTraceEnabled()) {
                LOG.trace("SQL: {}", (Object)sqlDropTable);
            }
        }
        this.jdbcTemplate.execute(sqlDropTable);
        if (PostgreSqlQueryUtils.getTableAttributesReadonly(entityType).findAny().isPresent()) {
            String sqlDropFunctionValidateUpdate = PostgreSqlQueryGenerator.getSqlDropFunctionValidateUpdate(entityType);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Dropping trigger function for entity [{}]", (Object)entityType.getId());
                if (LOG.isTraceEnabled()) {
                    LOG.trace("SQL: {}", (Object)sqlDropFunctionValidateUpdate);
                }
            }
            this.jdbcTemplate.execute(sqlDropFunctionValidateUpdate);
        }
    }

    public void addAttribute(EntityType entityType, Attribute attr) {
        if (entityType.isAbstract()) {
            throw new MolgenisDataException(String.format("Cannot add attribute [%s] to abstract entity type [%s].", attr.getName(), entityType.getId()));
        }
        if (entityType.getAttribute(attr.getName()) != null) {
            throw new MolgenisDataException(String.format("Adding attribute operation failed. Attribute already exists [%s]", attr.getName()));
        }
        this.addAttributeInternal(entityType, attr);
    }

    public void updateAttribute(EntityType entityType, Attribute attr, Attribute updatedAttr) {
        if (entityType.isAbstract()) {
            throw new MolgenisDataException(String.format("Cannot update attribute [%s] for abstract entity type [%s].", attr.getName(), entityType.getId()));
        }
        if (!PostgreSqlRepositoryCollection.isPersisted(attr) && !PostgreSqlRepositoryCollection.isPersisted(updatedAttr)) {
            return;
        }
        if (PostgreSqlRepositoryCollection.isPersisted(attr) && !PostgreSqlRepositoryCollection.isPersisted(updatedAttr)) {
            this.deleteAttribute(entityType, attr);
        } else if (!PostgreSqlRepositoryCollection.isPersisted(attr) && PostgreSqlRepositoryCollection.isPersisted(updatedAttr)) {
            this.addAttributeInternal(entityType, updatedAttr);
        } else {
            this.updateColumn(entityType, attr, updatedAttr);
        }
    }

    public void deleteAttribute(EntityType entityType, Attribute attr) {
        if (entityType.isAbstract()) {
            throw new MolgenisDataException(String.format("Cannot delete attribute [%s] from abstract entity type [%s].", attr.getName(), entityType.getId()));
        }
        if (entityType.getAttribute(attr.getName()) == null) {
            throw new UnknownAttributeException(String.format("Unknown attribute [%s]", attr.getName()));
        }
        if (!PostgreSqlRepositoryCollection.isPersisted(attr)) {
            return;
        }
        if (attr.getDataType() != AttributeType.ONE_TO_MANY || !attr.isMappedBy()) {
            if (EntityTypeUtils.isMultipleReferenceType((Attribute)attr)) {
                this.dropJunctionTable(entityType, attr);
            } else {
                this.dropColumn(entityType, attr);
            }
        }
    }

    private void addAttributeInternal(EntityType entityType, Attribute attr) {
        if (!PostgreSqlRepositoryCollection.isPersisted(attr)) {
            return;
        }
        if (attr.getDataType() != AttributeType.ONE_TO_MANY || !attr.isMappedBy()) {
            if (EntityTypeUtils.isMultipleReferenceType((Attribute)attr)) {
                this.createJunctionTable(entityType, attr);
            } else {
                this.createColumn(entityType, attr);
            }
        }
    }

    private static boolean isPersisted(Attribute attr) {
        return !attr.hasExpression() && attr.getDataType() != AttributeType.COMPOUND;
    }

    private void updateColumn(EntityType entityType, Attribute attr, Attribute updatedAttr) {
        if (!Objects.equals(attr.isNillable(), updatedAttr.isNillable())) {
            this.updateNillable(entityType, attr, updatedAttr);
        }
        if (!Objects.equals(attr.isUnique(), updatedAttr.isUnique())) {
            this.updateUnique(entityType, attr, updatedAttr);
        }
        if (!Objects.equals(attr.isReadOnly(), updatedAttr.isReadOnly())) {
            this.updateReadonly(entityType, attr, updatedAttr);
        }
        if (!Objects.equals(attr.getDataType(), updatedAttr.getDataType())) {
            this.updateDataType(entityType, attr, updatedAttr);
        }
        if (attr.getRefEntity() != null && updatedAttr.getRefEntity() != null && !attr.getRefEntity().getId().equals(updatedAttr.getRefEntity().getId())) {
            this.updateRefEntity(entityType, attr, updatedAttr);
        }
        if (!Objects.equals(attr.getEnumOptions(), updatedAttr.getEnumOptions())) {
            this.updateEnumOptions(entityType, attr, updatedAttr);
        }
    }

    private void updateRefEntity(EntityType entityType, Attribute attr, Attribute updatedAttr) {
        if (EntityTypeUtils.isSingleReferenceType((Attribute)attr) && EntityTypeUtils.isSingleReferenceType((Attribute)updatedAttr)) {
            this.dropForeignKey(entityType, attr);
            if (attr.getRefEntity().getIdAttribute().getDataType() != updatedAttr.getRefEntity().getIdAttribute().getDataType()) {
                this.updateColumnDataType(entityType, updatedAttr);
            }
            this.createForeignKey(entityType, updatedAttr);
        } else if (EntityTypeUtils.isMultipleReferenceType((Attribute)attr) && EntityTypeUtils.isMultipleReferenceType((Attribute)updatedAttr)) {
            throw new MolgenisDataException(String.format("Updating entity [%s] attribute [%s] referenced entity from [%s] to [%s] not allowed for type [%s]", entityType.getId(), attr.getName(), attr.getRefEntity().getId(), updatedAttr.getRefEntity().getId(), updatedAttr.getDataType().toString()));
        }
    }

    private void updateEnumOptions(EntityType entityType, Attribute attr, Attribute updatedAttr) {
        if (attr.getDataType() == AttributeType.ENUM) {
            if (updatedAttr.getDataType() == AttributeType.ENUM) {
                this.dropCheckConstraint(entityType, attr);
                this.createCheckConstraint(entityType, updatedAttr);
            } else {
                this.dropCheckConstraint(entityType, attr);
            }
        } else if (updatedAttr.getDataType() == AttributeType.ENUM) {
            this.createCheckConstraint(entityType, updatedAttr);
        }
    }

    private void updateDataType(EntityType entityType, Attribute attr, Attribute updatedAttr) {
        Attribute idAttr = entityType.getIdAttribute();
        if (idAttr != null && idAttr.getName().equals(attr.getName())) {
            throw new MolgenisDataException(String.format("Data type of entity [%s] attribute [%s] cannot be modified, because [%s] is an ID attribute.", entityType.getId(), attr.getName(), attr.getName()));
        }
        if (EntityTypeUtils.isSingleReferenceType((Attribute)attr) && EntityTypeUtils.isSingleReferenceType((Attribute)updatedAttr)) {
            return;
        }
        if (EntityTypeUtils.isMultipleReferenceType((Attribute)attr) && EntityTypeUtils.isMultipleReferenceType((Attribute)updatedAttr)) {
            return;
        }
        if (EntityTypeUtils.isSingleReferenceType((Attribute)attr) && !EntityTypeUtils.isReferenceType((Attribute)updatedAttr)) {
            this.dropForeignKey(entityType, attr);
        }
        this.updateColumnDataType(entityType, updatedAttr);
        if (!EntityTypeUtils.isReferenceType((Attribute)attr) && EntityTypeUtils.isSingleReferenceType((Attribute)updatedAttr)) {
            this.createForeignKey(entityType, updatedAttr);
        }
    }

    private void updateUnique(EntityType entityType, Attribute attr, Attribute updatedAttr) {
        if (attr.isUnique() && !updatedAttr.isUnique()) {
            Attribute idAttr = entityType.getIdAttribute();
            if (idAttr != null && idAttr.getName().equals(attr.getName())) {
                throw new MolgenisDataException(String.format("ID attribute [%s] of entity [%s] must be unique", attr.getName(), entityType.getId()));
            }
            this.dropUniqueKey(entityType, updatedAttr);
        } else if (!attr.isUnique() && updatedAttr.isUnique()) {
            this.createUniqueKey(entityType, updatedAttr);
        }
    }

    private void updateReadonly(EntityType entityType, Attribute attr, Attribute updatedAttr) {
        LinkedHashMap readonlyTableAttrs = PostgreSqlQueryUtils.getTableAttributesReadonly(entityType).collect(Collectors.toMap(Attribute::getName, Function.identity(), (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new));
        if (!readonlyTableAttrs.isEmpty()) {
            this.dropTableTriggers(entityType);
        }
        if (attr.isReadOnly() && !updatedAttr.isReadOnly()) {
            readonlyTableAttrs.remove(attr.getName());
        } else if (!attr.isReadOnly() && updatedAttr.isReadOnly()) {
            readonlyTableAttrs.put(updatedAttr.getName(), updatedAttr);
        }
        if (!readonlyTableAttrs.isEmpty()) {
            this.createTableTriggers(entityType, readonlyTableAttrs.values());
        }
    }

    private PostgreSqlRepository createPostgreSqlRepository() {
        return new PostgreSqlRepository(this.postgreSqlEntityFactory, this.jdbcTemplate, this.dataSource);
    }

    private boolean isTableExists(EntityType entityType) {
        return this.isTableExists(PostgreSqlNameGenerator.getTableName(entityType, false));
    }

    private boolean isTableExists(String tableName) {
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            DatabaseMetaData dbm = conn.getMetaData();
            ResultSet tables = dbm.getTables(null, null, tableName, new String[]{"TABLE"});
            boolean bl = tables.next();
            return bl;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void updateNillable(EntityType entityType, Attribute attr, Attribute updatedAttr) {
        if (attr.isNillable() && !updatedAttr.isNillable()) {
            String sqlSetNotNull = PostgreSqlQueryGenerator.getSqlSetNotNull(entityType, updatedAttr);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Creating not null constraint for entity [{}] attribute [{}]", (Object)entityType.getId(), (Object)attr.getName());
                if (LOG.isTraceEnabled()) {
                    LOG.trace("SQL: {}", (Object)sqlSetNotNull);
                }
            }
            this.jdbcTemplate.execute(sqlSetNotNull);
        } else if (!attr.isNillable() && updatedAttr.isNillable()) {
            Attribute idAttr = entityType.getIdAttribute();
            if (idAttr != null && idAttr.getName().equals(attr.getName())) {
                throw new MolgenisDataException(String.format("ID attribute [%s] of entity [%s] cannot be nullable", attr.getName(), entityType.getId()));
            }
            String sqlDropNotNull = PostgreSqlQueryGenerator.getSqlDropNotNull(entityType, updatedAttr);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Removing not null constraint for entity [{}] attribute [{}]", (Object)entityType.getId(), (Object)attr.getName());
                if (LOG.isTraceEnabled()) {
                    LOG.trace("SQL: {}", (Object)sqlDropNotNull);
                }
            }
            this.jdbcTemplate.execute(sqlDropNotNull);
        }
    }

    private void createTable(EntityType entityType) {
        String createTableSql = PostgreSqlQueryGenerator.getSqlCreateTable(entityType);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating table for entity [{}]", (Object)entityType.getId());
            if (LOG.isTraceEnabled()) {
                LOG.trace("SQL: {}", (Object)createTableSql);
            }
        }
        this.jdbcTemplate.execute(createTableSql);
        this.createTableTriggers(entityType);
        this.createJunctionTables(entityType);
    }

    private void createTableTriggers(EntityType entityType) {
        List<Attribute> readonlyTableAttrs = PostgreSqlQueryUtils.getTableAttributesReadonly(entityType).collect(Collectors.toList());
        if (!readonlyTableAttrs.isEmpty()) {
            this.createTableTriggers(entityType, readonlyTableAttrs);
        }
    }

    private void createTableTriggers(EntityType entityType, Collection<Attribute> readonlyTableAttrs) {
        String createFunctionSql = PostgreSqlQueryGenerator.getSqlCreateFunctionValidateUpdate(entityType, readonlyTableAttrs);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating update trigger function for entity [{}]", (Object)entityType.getId());
            if (LOG.isTraceEnabled()) {
                LOG.trace("SQL: {}", (Object)createFunctionSql);
            }
        }
        this.jdbcTemplate.execute(createFunctionSql);
        String createUpdateTriggerSql = PostgreSqlQueryGenerator.getSqlCreateUpdateTrigger(entityType, readonlyTableAttrs);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating update trigger for entity [{}]", (Object)entityType.getId());
            if (LOG.isTraceEnabled()) {
                LOG.trace("SQL: {}", (Object)createUpdateTriggerSql);
            }
        }
        this.jdbcTemplate.execute(createUpdateTriggerSql);
    }

    private void updateTableTriggers(EntityType entityType, Collection<Attribute> readonlyTableAttrs) {
        this.dropTableTriggers(entityType);
        this.createTableTriggers(entityType, readonlyTableAttrs);
    }

    private void dropTableTriggers(EntityType entityType) {
        String dropUpdateTriggerSql = PostgreSqlQueryGenerator.getSqlDropUpdateTrigger(entityType);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Deleting update trigger for entity [{}]", (Object)entityType.getId());
            if (LOG.isTraceEnabled()) {
                LOG.trace("SQL: {}", (Object)dropUpdateTriggerSql);
            }
        }
        this.jdbcTemplate.execute(dropUpdateTriggerSql);
        String dropFunctionValidateUpdateSql = PostgreSqlQueryGenerator.getSqlDropFunctionValidateUpdate(entityType);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Deleting update trigger function for entity [{}]", (Object)entityType.getId());
            if (LOG.isTraceEnabled()) {
                LOG.trace("SQL: {}", (Object)dropFunctionValidateUpdateSql);
            }
        }
        this.jdbcTemplate.execute(dropFunctionValidateUpdateSql);
    }

    private void createJunctionTables(EntityType entityType) {
        PostgreSqlQueryUtils.getJunctionTableAttributes(entityType).forEach(attr -> this.createJunctionTable(entityType, (Attribute)attr));
    }

    private void createForeignKey(EntityType entityType, Attribute attr) {
        String createForeignKeySql = PostgreSqlQueryGenerator.getSqlCreateForeignKey(entityType, attr);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating foreign key for entity [{}] attribute [{}]", (Object)entityType.getId(), (Object)attr.getName());
            if (LOG.isTraceEnabled()) {
                LOG.trace("SQL: {}", (Object)createForeignKeySql);
            }
        }
        this.jdbcTemplate.execute(createForeignKeySql);
    }

    private void dropForeignKey(EntityType entityType, Attribute attr) {
        String dropForeignKeySql = PostgreSqlQueryGenerator.getSqlDropForeignKey(entityType, attr);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Dropping foreign key for entity [{}] attribute [{}]", (Object)entityType.getId(), (Object)attr.getName());
            if (LOG.isTraceEnabled()) {
                LOG.trace("SQL: {}", (Object)dropForeignKeySql);
            }
        }
        this.jdbcTemplate.execute(dropForeignKeySql);
    }

    private void createUniqueKey(EntityType entityType, Attribute attr) {
        String createUniqueKeySql = PostgreSqlQueryGenerator.getSqlCreateUniqueKey(entityType, attr);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating unique key for entity [{}] attribute [{}]", (Object)entityType.getId(), (Object)attr.getName());
            if (LOG.isTraceEnabled()) {
                LOG.trace("SQL: {}", (Object)createUniqueKeySql);
            }
        }
        this.jdbcTemplate.execute(createUniqueKeySql);
    }

    private void dropUniqueKey(EntityType entityType, Attribute attr) {
        String dropUniqueKeySql = PostgreSqlQueryGenerator.getSqlDropUniqueKey(entityType, attr);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Dropping unique key for entity [{}] attribute [{}]", (Object)entityType.getId(), (Object)attr.getName());
            if (LOG.isTraceEnabled()) {
                LOG.trace("SQL: {}", (Object)dropUniqueKeySql);
            }
        }
        this.jdbcTemplate.execute(dropUniqueKeySql);
    }

    private void createCheckConstraint(EntityType entityType, Attribute attr) {
        String sqlCreateCheckConstraint = PostgreSqlQueryGenerator.getSqlCreateCheckConstraint(entityType, attr);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating check constraint for entity [{}] attribute [{}]", (Object)entityType.getId(), (Object)attr.getName());
            if (LOG.isTraceEnabled()) {
                LOG.trace("SQL: {}", (Object)sqlCreateCheckConstraint);
            }
        }
        this.jdbcTemplate.execute(sqlCreateCheckConstraint);
    }

    private void dropCheckConstraint(EntityType entityType, Attribute attr) {
        String sqlDropCheckConstraint = PostgreSqlQueryGenerator.getSqlDropCheckConstraint(entityType, attr);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Dropping check constraint for entity [{}] attribute [{}]", (Object)entityType.getId(), (Object)attr.getName());
            if (LOG.isTraceEnabled()) {
                LOG.trace("SQL: {}", (Object)sqlDropCheckConstraint);
            }
        }
        this.jdbcTemplate.execute(sqlDropCheckConstraint);
    }

    private void createColumn(EntityType entityType, Attribute attr) {
        String addColumnSql = PostgreSqlQueryGenerator.getSqlAddColumn(entityType, attr);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating column for entity [{}] attribute [{}]", (Object)entityType.getId(), (Object)attr.getName());
            if (LOG.isTraceEnabled()) {
                LOG.trace("SQL: {}", (Object)addColumnSql);
            }
        }
        this.jdbcTemplate.execute(addColumnSql);
        if (attr.isReadOnly()) {
            Stream<Attribute> tableAttrsReadonly = PostgreSqlQueryUtils.getTableAttributesReadonly(entityType);
            Stream<Attribute> updatedTableAttrsReadonly = PostgreSqlQueryUtils.isTableAttribute(attr) ? Stream.concat(tableAttrsReadonly, Stream.of(attr)) : tableAttrsReadonly;
            this.updateTableTriggers(entityType, updatedTableAttrsReadonly.collect(Collectors.toList()));
        }
    }

    private void dropColumn(EntityType entityType, Attribute attr) {
        if (attr.isReadOnly()) {
            LinkedHashMap updatedReadonlyTableAttrs = PostgreSqlQueryUtils.getTableAttributesReadonly(entityType).collect(Collectors.toMap(Attribute::getName, Function.identity(), (u, v) -> {
                throw new IllegalStateException(String.format("Duplicate key %s", u));
            }, LinkedHashMap::new));
            updatedReadonlyTableAttrs.remove(attr.getName());
            this.updateTableTriggers(entityType, updatedReadonlyTableAttrs.values());
        }
        String dropColumnSql = PostgreSqlQueryGenerator.getSqlDropColumn(entityType, attr);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Dropping column for entity [{}] attribute [{}]", (Object)entityType.getId(), (Object)attr.getName());
            if (LOG.isTraceEnabled()) {
                LOG.trace("SQL: {}", (Object)dropColumnSql);
            }
        }
        this.jdbcTemplate.execute(dropColumnSql);
    }

    private void updateColumnDataType(EntityType entityType, Attribute attr) {
        String sqlSetDataType = PostgreSqlQueryGenerator.getSqlSetDataType(entityType, attr);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Changing data type of entity [{}] attribute [{}] to [{}]", new Object[]{entityType.getId(), attr.getName(), attr.getDataType().toString()});
            if (LOG.isTraceEnabled()) {
                LOG.trace("SQL: {}", (Object)sqlSetDataType);
            }
        }
        this.jdbcTemplate.execute(sqlSetDataType);
    }

    private void createJunctionTable(EntityType entityType, Attribute attr) {
        String createJunctionTableSql = PostgreSqlQueryGenerator.getSqlCreateJunctionTable(entityType, attr);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating junction table for entity [{}] attribute [{}]", (Object)entityType.getId(), (Object)attr.getName());
            if (LOG.isTraceEnabled()) {
                LOG.trace("SQL: {}", (Object)createJunctionTableSql);
            }
        }
        this.jdbcTemplate.execute(createJunctionTableSql);
        String createJunctionTableIndexSql = PostgreSqlQueryGenerator.getSqlCreateJunctionTableIndex(entityType, attr);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating junction table index for entity [{}] attribute [{}]", (Object)entityType.getId(), (Object)attr.getName());
            if (LOG.isTraceEnabled()) {
                LOG.trace("SQL: {}", (Object)createJunctionTableIndexSql);
            }
        }
        this.jdbcTemplate.execute(createJunctionTableIndexSql);
    }

    private void dropJunctionTable(EntityType entityType, Attribute mrefAttr) {
        String sqlDropJunctionTable = PostgreSqlQueryGenerator.getSqlDropJunctionTable(entityType, mrefAttr);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Dropping junction table for entity [{}] attribute [{}]", (Object)entityType.getId(), (Object)mrefAttr.getName());
            if (LOG.isTraceEnabled()) {
                LOG.trace("SQL: {}", (Object)sqlDropJunctionTable);
            }
        }
        this.jdbcTemplate.execute(sqlDropJunctionTable);
    }
}

