/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.postgresql;

import java.util.regex.Pattern;
import org.molgenis.data.meta.AbstractMetadataIdGenerator;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;

public class PostgreSqlIdGenerator
extends AbstractMetadataIdGenerator {
    private static final Pattern PATTERN_WORD = Pattern.compile("\\w*");
    private static final Pattern PATTERN_WORD_REPLACE = Pattern.compile("\\W");
    private static final char SEPARATOR = '#';
    private final int maxIdentifierByteLength;

    PostgreSqlIdGenerator(int maxIdentifierByteLength) {
        if (maxIdentifierByteLength < 10) {
            throw new IllegalArgumentException("Max identifier byte length must be >= 10");
        }
        this.maxIdentifierByteLength = maxIdentifierByteLength;
    }

    public String generateId(EntityType entityType) {
        String idHash = this.generateHashcode(entityType.getId());
        String truncatedId = this.truncateName(this.cleanName(entityType.getId()));
        return truncatedId + '#' + idHash;
    }

    public String generateId(Attribute attribute) {
        String attrName = attribute.getName();
        if (PATTERN_WORD.matcher(attrName).matches() && attrName.length() <= this.maxIdentifierByteLength) {
            return attrName;
        }
        String idPart = this.generateHashcode(attribute.getIdentifier());
        String namePart = this.truncateName(this.cleanName(attribute.getName()));
        return namePart + '#' + idPart;
    }

    private String cleanName(String name) {
        return PATTERN_WORD_REPLACE.matcher(name).replaceAll("");
    }

    private String truncateName(String name) {
        int maxNameLength = this.maxIdentifierByteLength - 8 - 1;
        return name.length() < maxNameLength ? name : name.substring(0, maxNameLength);
    }
}

