/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.transaction;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.sql.DataSource;
import org.apache.commons.logging.LogFactory;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.populate.IdGenerator;
import org.molgenis.data.transaction.MolgenisTransaction;
import org.molgenis.data.transaction.TransactionExceptionTranslator;
import org.molgenis.data.transaction.TransactionExceptionTranslatorRegistry;
import org.molgenis.data.transaction.TransactionListener;
import org.molgenis.data.transaction.TransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class PostgreSqlTransactionManager
extends DataSourceTransactionManager
implements TransactionManager {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(PostgreSqlTransactionManager.class);
    private final IdGenerator idGenerator;
    private final List<TransactionListener> transactionListeners = new ArrayList<TransactionListener>();
    private final TransactionExceptionTranslatorRegistry transactionExceptionTranslatorRegistry;

    public PostgreSqlTransactionManager(IdGenerator idGenerator, DataSource dataSource, TransactionExceptionTranslatorRegistry transactionExceptionTranslatorRegistry) {
        super(dataSource);
        this.logger = LogFactory.getLog(DataSourceTransactionManager.class);
        this.setNestedTransactionAllowed(false);
        this.idGenerator = idGenerator;
        this.transactionExceptionTranslatorRegistry = Objects.requireNonNull(transactionExceptionTranslatorRegistry);
    }

    public void addTransactionListener(TransactionListener transactionListener) {
        this.transactionListeners.add(transactionListener);
    }

    protected Object doGetTransaction() throws TransactionException {
        Object dataSourceTransactionManager = super.doGetTransaction();
        String id = TransactionSynchronizationManager.hasResource((Object)"transactionId") ? (String)TransactionSynchronizationManager.getResource((Object)"transactionId") : this.idGenerator.generateId().toLowerCase();
        return new MolgenisTransaction(id, dataSourceTransactionManager);
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) throws TransactionException {
        MolgenisTransaction molgenisTransaction = (MolgenisTransaction)transaction;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Start transaction [{}]", (Object)molgenisTransaction.getId());
        }
        super.doBegin(molgenisTransaction.getDataSourceTransaction(), definition);
        if (!definition.isReadOnly()) {
            TransactionSynchronizationManager.bindResource((Object)"transactionId", (Object)molgenisTransaction.getId());
            this.transactionListeners.forEach(j -> j.transactionStarted(molgenisTransaction.getId()));
        }
    }

    protected void doCommit(DefaultTransactionStatus status) throws TransactionException {
        MolgenisTransaction transaction = (MolgenisTransaction)status.getTransaction();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Commit transaction [{}]", (Object)transaction.getId());
        }
        DefaultTransactionStatus jpaTransactionStatus = new DefaultTransactionStatus(transaction.getDataSourceTransaction(), status.isNewTransaction(), status.isNewSynchronization(), status.isReadOnly(), status.isDebug(), status.getSuspendedResources());
        if (!status.isReadOnly()) {
            this.transactionListeners.forEach(j -> j.commitTransaction(transaction.getId()));
        }
        try {
            super.doCommit(jpaTransactionStatus);
        }
        catch (TransactionException e) {
            throw this.translateTransactionException(e);
        }
        if (!status.isReadOnly()) {
            this.transactionListeners.forEach(j -> j.afterCommitTransaction(transaction.getId()));
        }
    }

    protected void doRollback(DefaultTransactionStatus status) throws TransactionException {
        MolgenisTransaction transaction = (MolgenisTransaction)status.getTransaction();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Rollback transaction [{}]", (Object)transaction.getId());
        }
        DefaultTransactionStatus jpaTransactionStatus = new DefaultTransactionStatus(transaction.getDataSourceTransaction(), status.isNewTransaction(), status.isNewSynchronization(), status.isReadOnly(), status.isDebug(), status.getSuspendedResources());
        if (!status.isReadOnly()) {
            this.transactionListeners.forEach(j -> j.rollbackTransaction(transaction.getId()));
        }
        super.doRollback(jpaTransactionStatus);
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) {
        MolgenisTransaction transaction = (MolgenisTransaction)status.getTransaction();
        DefaultTransactionStatus jpaTransactionStatus = new DefaultTransactionStatus(transaction.getDataSourceTransaction(), status.isNewTransaction(), status.isNewSynchronization(), status.isReadOnly(), status.isDebug(), status.getSuspendedResources());
        super.doSetRollbackOnly(jpaTransactionStatus);
    }

    protected boolean isExistingTransaction(Object transaction) {
        return super.isExistingTransaction(((MolgenisTransaction)transaction).getDataSourceTransaction());
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        MolgenisTransaction molgenisTransaction = (MolgenisTransaction)transaction;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cleanup transaction [{}]", (Object)molgenisTransaction.getId());
        }
        super.doCleanupAfterCompletion(molgenisTransaction.getDataSourceTransaction());
        TransactionSynchronizationManager.unbindResourceIfPossible((Object)"transactionId");
        this.transactionListeners.forEach(j -> j.doCleanupAfterCompletion(molgenisTransaction.getId()));
    }

    protected Object doSuspend(Object transaction) {
        MolgenisTransaction molgenisTransaction = (MolgenisTransaction)transaction;
        return super.doSuspend(molgenisTransaction.getDataSourceTransaction());
    }

    protected void doResume(Object transaction, Object suspendedResources) {
        MolgenisTransaction molgenisTransaction = (MolgenisTransaction)transaction;
        super.doResume(molgenisTransaction.getDataSourceTransaction(), suspendedResources);
    }

    private MolgenisDataException translateTransactionException(TransactionException transactionException) {
        for (TransactionExceptionTranslator transactionExceptionTranslator : this.transactionExceptionTranslatorRegistry.getTransactionExceptionTranslators()) {
            MolgenisDataException molgenisDataException = transactionExceptionTranslator.doTranslate(transactionException);
            if (molgenisDataException == null) continue;
            return molgenisDataException;
        }
        throw new RuntimeException(String.format("Unexpected exception class [%s]", ((Object)((Object)transactionException)).getClass().getSimpleName()), transactionException);
    }
}

