/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.postgresql.identifier;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.postgresql.PostgreSqlNameGenerator;
import org.molgenis.data.postgresql.identifier.AttributeDescription;
import org.molgenis.data.postgresql.identifier.EntityTypeDescription;
import org.molgenis.data.postgresql.identifier.EntityTypeRegistry;
import org.molgenis.data.support.EntityTypeUtils;
import org.molgenis.data.transaction.DefaultMolgenisTransactionListener;
import org.molgenis.data.transaction.TransactionListener;
import org.molgenis.data.transaction.TransactionManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Component
public class EntityTypeRegistryImpl
extends DefaultMolgenisTransactionListener
implements EntityTypeRegistry {
    private final ConcurrentMap<String, EntityTypeDescription> entityTypeDescriptionMap = new ConcurrentHashMap<String, EntityTypeDescription>();
    private final ConcurrentMap<String, Map<String, EntityTypeDescription>> transactionsEntityTypeDescriptionMap = new ConcurrentHashMap<String, Map<String, EntityTypeDescription>>();

    @Autowired
    public EntityTypeRegistryImpl(TransactionManager transactionManager) {
        transactionManager.addTransactionListener((TransactionListener)this);
    }

    @Override
    public void registerEntityType(EntityType entityType) {
        String tableName = this.getTableName(entityType);
        EntityTypeDescription entityTypeDescription = this.createEntityTypeDescription(entityType);
        this.getEntityTypeDescriptionMap().put(tableName, entityTypeDescription);
        this.putJunctionTableNames(entityType, entityTypeDescription);
    }

    @Override
    public void unregisterEntityType(EntityType entityType) {
        String tableName = this.getTableName(entityType);
        this.getEntityTypeDescriptionMap().put(tableName, null);
        this.putJunctionTableNames(entityType, null);
    }

    private void putJunctionTableNames(EntityType entityType, EntityTypeDescription entityTypeDescription) {
        StreamSupport.stream(entityType.getAllAttributes().spliterator(), false).filter(EntityTypeUtils::isReferenceType).map(attribute -> PostgreSqlNameGenerator.getJunctionTableName(entityType, attribute, false)).forEach(junctionName -> this.getEntityTypeDescriptionMap().put((String)junctionName, entityTypeDescription));
    }

    @Override
    public EntityTypeDescription getEntityTypeDescription(String tableName) {
        Map transactionEntityTypeDescriptionMap = (Map)this.transactionsEntityTypeDescriptionMap.get(this.getTransactionId());
        if (transactionEntityTypeDescriptionMap != null && transactionEntityTypeDescriptionMap.containsKey(tableName)) {
            return (EntityTypeDescription)transactionEntityTypeDescriptionMap.get(tableName);
        }
        return (EntityTypeDescription)this.entityTypeDescriptionMap.get(tableName);
    }

    public void afterCommitTransaction(String transactionId) {
        Map transactionEntityTypeDescriptionMap = (Map)this.transactionsEntityTypeDescriptionMap.remove(transactionId);
        if (transactionEntityTypeDescriptionMap != null) {
            transactionEntityTypeDescriptionMap.forEach((tableName, entityTypeDescription) -> {
                if (entityTypeDescription != null) {
                    this.entityTypeDescriptionMap.put((String)tableName, (EntityTypeDescription)entityTypeDescription);
                } else {
                    this.entityTypeDescriptionMap.remove(tableName);
                }
            });
        }
    }

    public void rollbackTransaction(String transactionId) {
        this.transactionsEntityTypeDescriptionMap.remove(transactionId);
    }

    private String getTransactionId() {
        return (String)TransactionSynchronizationManager.getResource((Object)"transactionId");
    }

    private String getTableName(EntityType entityType) {
        return PostgreSqlNameGenerator.getTableName(entityType, false);
    }

    private String getColumnName(Attribute attr) {
        return PostgreSqlNameGenerator.getColumnName(attr, false);
    }

    private EntityTypeDescription createEntityTypeDescription(EntityType entityType) {
        String fullyQualifiedName = entityType.getId();
        ImmutableMap attrDescriptionMap = ImmutableMap.copyOf(this.createAttributeDescriptionMap(entityType));
        return EntityTypeDescription.create(fullyQualifiedName, (ImmutableMap<String, AttributeDescription>)attrDescriptionMap);
    }

    private Map<String, AttributeDescription> createAttributeDescriptionMap(EntityType entityType) {
        return StreamSupport.stream(entityType.getAllAttributes().spliterator(), false).collect(Collectors.toMap(this::getColumnName, this::createAttributeDescription));
    }

    private AttributeDescription createAttributeDescription(Attribute attribute) {
        return AttributeDescription.create(attribute.getName());
    }

    private Map<String, EntityTypeDescription> getEntityTypeDescriptionMap() {
        return this.transactionsEntityTypeDescriptionMap.computeIfAbsent(this.getTransactionId(), k -> new HashMap());
    }
}

