/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.postgresql;

import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.molgenis.data.DataService;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.support.EntityTypeUtils;
import org.molgenis.util.ApplicationContextProvider;

class PostgreSqlQueryUtils {
    private PostgreSqlQueryUtils() {
    }

    static Stream<Attribute> getPersistedAttributes(EntityType entityType) {
        return StreamSupport.stream(entityType.getAtomicAttributes().spliterator(), false).filter(atomicAttr -> atomicAttr.getExpression() == null);
    }

    static Stream<Attribute> getJunctionTableAttributes(EntityType entityType) {
        return PostgreSqlQueryUtils.getPersistedAttributes(entityType).filter(attr -> EntityTypeUtils.isMultipleReferenceType((Attribute)attr) && (attr.getDataType() != AttributeType.ONE_TO_MANY || !attr.isMappedBy()));
    }

    static Stream<Attribute> getTableAttributes(EntityType entityType) {
        return PostgreSqlQueryUtils.getPersistedAttributes(entityType).filter(PostgreSqlQueryUtils::isTableAttribute);
    }

    static boolean isTableAttribute(Attribute attr) {
        return !EntityTypeUtils.isMultipleReferenceType((Attribute)attr) && (attr.getDataType() != AttributeType.ONE_TO_MANY || !attr.isMappedBy());
    }

    static Stream<Attribute> getTableAttributesReadonly(EntityType entityType) {
        return PostgreSqlQueryUtils.getTableAttributes(entityType).filter(Attribute::isReadOnly);
    }

    static boolean isPersistedInPostgreSql(EntityType entityType) {
        String backend = entityType.getBackend();
        if (backend == null) {
            if (null != ApplicationContextProvider.getApplicationContext()) {
                DataService dataService = (DataService)ApplicationContextProvider.getApplicationContext().getBean(DataService.class);
                backend = dataService.getMeta().getDefaultBackend().getName();
            } else {
                return true;
            }
        }
        return backend.equals("PostgreSQL");
    }
}

