/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.postgresql;

import javax.sql.DataSource;
import org.molgenis.data.DataService;
import org.molgenis.data.RepositoryCollection;
import org.molgenis.data.meta.util.AttributeCopier;
import org.molgenis.data.meta.util.EntityTypeCopier;
import org.molgenis.data.postgresql.PostgreSqlEntityFactory;
import org.molgenis.data.postgresql.PostgreSqlExceptionTranslator;
import org.molgenis.data.postgresql.PostgreSqlRepositoryCollection;
import org.molgenis.data.postgresql.PostgreSqlRepositoryCollectionDecorator;
import org.molgenis.data.postgresql.identifier.EntityTypeRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.SQLExceptionTranslator;

@Configuration
public class PostgreSqlConfiguration {
    @Autowired
    private PostgreSqlEntityFactory postgreSqlEntityFactory;
    @Autowired
    private DataSource dataSource;
    @Autowired
    private DataService dataService;
    @Autowired
    private PostgreSqlExceptionTranslator postgreSqlExceptionTranslator;
    @Autowired
    private EntityTypeRegistry entityTypeRegistry;
    @Autowired
    private EntityTypeCopier entityTypeCopier;
    @Autowired
    private AttributeCopier attributeCopier;

    @Bean
    public JdbcTemplate jdbcTemplate() {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        jdbcTemplate.setExceptionTranslator((SQLExceptionTranslator)this.postgreSqlExceptionTranslator);
        return jdbcTemplate;
    }

    @Bean
    public RepositoryCollection postgreSqlRepositoryCollection() {
        return new PostgreSqlRepositoryCollectionDecorator((RepositoryCollection)new PostgreSqlRepositoryCollection(this.postgreSqlEntityFactory, this.dataSource, this.jdbcTemplate(), this.dataService), this.entityTypeRegistry, this.entityTypeCopier, this.attributeCopier);
    }
}

