/*
 * Decompiled with CFR 0.152.
 */
package org.mod4j.runtime.validation;

import org.springframework.util.Assert;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class MinValueValidator
implements Validator {
    private String field;
    private long min;
    private Class clazz;

    public MinValueValidator(Class clazz, String field, long min) {
        this.clazz = clazz;
        this.field = field;
        this.min = min;
    }

    public boolean supports(Class clazz) {
        return this.clazz.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        Long value = null;
        if (errors.getFieldValue(this.field) instanceof Integer) {
            value = ((Integer)errors.getFieldValue(this.field)).longValue();
        } else if (errors.getFieldValue(this.field) instanceof Long) {
            value = (Long)errors.getFieldValue(this.field);
        }
        if (value != null) {
            Assert.notNull((Object)value);
            if (value < this.min) {
                errors.rejectValue(this.field, "field.value.min", (Object[])new Long[]{new Long(this.min), new Long(value)}, this.field + " should be at least " + this.min + ", but was " + value);
            }
        }
    }
}

