/*
 * Decompiled with CFR 0.152.
 */
package org.mod4j.runtime.validation;

import org.springframework.util.Assert;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class MaxValueValidator
implements Validator {
    private String field;
    private long max;
    private Class clazz;

    public MaxValueValidator(Class clazz, String field, long max) {
        this.clazz = clazz;
        this.field = field;
        this.max = max;
    }

    public boolean supports(Class clazz) {
        return this.clazz.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        Long value = null;
        if (errors.getFieldValue(this.field) instanceof Integer) {
            value = ((Integer)errors.getFieldValue(this.field)).longValue();
        } else if (errors.getFieldValue(this.field) instanceof Long) {
            value = (Long)errors.getFieldValue(this.field);
        }
        if (value != null) {
            Assert.notNull((Object)value);
            if (value > this.max) {
                errors.rejectValue(this.field, "field.value.max", (Object[])new Long[]{new Long(this.max), new Long(value)}, this.field + " should be at most " + this.max + ", but was " + value);
            }
        }
    }
}

