/*
 * Decompiled with CFR 0.152.
 */
package org.mod4j.runtime.validation;

import java.util.List;
import org.mod4j.runtime.exception.BusinessRuleException;
import org.mod4j.runtime.validation.BusinessRuleValidationCallback;
import org.springframework.util.ClassUtils;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BusinessRuleValidationTemplate {
    private Object object;

    public BusinessRuleValidationTemplate(Object object) {
        this.object = object;
    }

    public void invokeValidator(final Validator validator) {
        this.execute(new BusinessRuleValidationCallback(){

            public void doValidate(Object object, Errors errors) {
                ValidationUtils.invokeValidator((Validator)validator, (Object)object, (Errors)errors);
            }
        });
    }

    public void invokeValidators(final List<Validator> validators) {
        this.execute(new BusinessRuleValidationCallback(){

            public void doValidate(Object object, Errors errors) {
                for (Validator validator : validators) {
                    ValidationUtils.invokeValidator((Validator)validator, (Object)object, (Errors)errors);
                }
            }
        });
    }

    public void execute(BusinessRuleValidationCallback action) {
        BindException errors = new BindException(this.object, ClassUtils.getShortNameAsProperty(this.object.getClass()));
        action.doValidate(this.object, (Errors)errors);
        if (errors.hasErrors()) {
            throw new BusinessRuleException((Throwable)errors);
        }
    }
}

