/*
 * Decompiled with CFR 0.152.
 */
package org.mod4j.runtime.validation;

import org.springframework.util.Assert;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;

public class BusinessRuleUtils {
    public static void validateEmptyOrWhitespace(Errors errors, String field) {
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)field, (String)"field.required");
    }

    public static void validateMinLength(Errors errors, String field, int min) {
        String value = (String)errors.getFieldValue(field);
        Assert.notNull((Object)value);
        int length = value.length();
        if (length < min) {
            errors.rejectValue(field, "field.length.min", (Object[])new Integer[]{new Integer(min), new Integer(length)}, field + " should be at least " + min + " long, but was " + length);
        }
    }

    public static void validateMaxLength(Errors errors, String field, int max) {
        String value = (String)errors.getFieldValue(field);
        Assert.notNull((Object)value);
        int length = value.length();
        if (length > max) {
            errors.rejectValue(field, "field.length.max", (Object[])new Integer[]{new Integer(max), new Integer(length)}, field + " should be at most " + max + " long, but was " + length);
        }
    }

    public static void validateMaxValue(Errors errors, String field, long max) {
        Long value = null;
        if (errors.getFieldValue(field) instanceof Integer) {
            value = ((Integer)errors.getFieldValue(field)).longValue();
        } else if (errors.getFieldValue(field) instanceof Long) {
            value = (Long)errors.getFieldValue(field);
        }
        Assert.notNull((Object)value);
        if (value > max) {
            errors.rejectValue(field, "field.value.max", (Object[])new Long[]{new Long(max), new Long(value)}, field + " should be at most " + max + ", but was " + value);
        }
    }

    public static void validateMinValue(Errors errors, String field, long min) {
        Long value = null;
        if (errors.getFieldValue(field) instanceof Integer) {
            value = ((Integer)errors.getFieldValue(field)).longValue();
        } else if (errors.getFieldValue(field) instanceof Long) {
            value = (Long)errors.getFieldValue(field);
        }
        if (value != null) {
            Assert.notNull((Object)value);
            if (value < min) {
                errors.rejectValue(field, "field.value.min", (Object[])new Long[]{new Long(min), new Long(value)}, field + " should be at least " + min + ", but was " + value);
            }
        }
    }
}

