/*
 * Decompiled with CFR 0.152.
 */
package org.mod4j.runtime.aspects;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.core.Ordered;

public class TimingAspect
implements Ordered {
    private static final Log log = LogFactory.getLog(TimingAspect.class);
    private int order;

    public Object time(ProceedingJoinPoint call) throws Throwable {
        long startTimer = System.currentTimeMillis();
        Object point = call.proceed();
        log.trace((Object)("Execution of method [" + call.getTarget().getClass().getName() + "." + call.getSignature().getName() + "] in " + (System.currentTimeMillis() - startTimer) + " milliseconds"));
        return point;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

