/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.hapifhir;

import org.json.JSONArray;
import org.json.JSONObject;

public class WellknownEndpointHelper {
    private static final String WELL_KNOWN_TOKEN_ENDPOINT_KEY = "token_endpoint";
    private static final String WELL_KNOWN_REGISTRATION_ENDPOINT_KEY = "registration_endpoint";
    private static final String RESPONSE_TYPES_SUPPORTED_KEY = "response_types_supported";
    private static final String SCOPES_SUPPORTED_KEY = "scopes_supported";

    public static String getWellKnownJson(String tokenEndpointUrl, String registrationEndpointUrl) {
        JSONArray scopesSupported = new JSONArray();
        scopesSupported.put((Object)"system/*.*");
        scopesSupported.put((Object)"system/*.read");
        scopesSupported.put((Object)"system/*.write");
        scopesSupported.put((Object)"offline_access");
        JSONArray responseTypesSupported = new JSONArray();
        responseTypesSupported.put((Object)"token");
        JSONObject wellKnownJson = new JSONObject();
        wellKnownJson.put(WELL_KNOWN_TOKEN_ENDPOINT_KEY, (Object)tokenEndpointUrl);
        wellKnownJson.put(RESPONSE_TYPES_SUPPORTED_KEY, (Object)responseTypesSupported);
        wellKnownJson.put(SCOPES_SUPPORTED_KEY, (Object)scopesSupported);
        if (registrationEndpointUrl != null) {
            wellKnownJson.put(WELL_KNOWN_REGISTRATION_ENDPOINT_KEY, (Object)registrationEndpointUrl);
        }
        return wellKnownJson.toString(2);
    }
}

